/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis;

import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.common.ErrorMessage;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MaterialNamenPruefer
extends Traverser {
    private Map matNames = new Hashtable();

    public void checkForDuplicates(MetaPlausibilisierung pl) throws CodegenException {
        assert (pl != null);
        pl.accept(this);
        this.errorCheck();
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)anObject;
        this.visitElements(plausi.getPLMaterialien());
    }

    @Override
    public void visitPLMaterial(MetaPLMaterial anObject) {
        this.addElement(this.matNames, anObject);
    }

    private boolean addElement(Map map, MetaStatspezObjekt element) {
        boolean result;
        List<DefaultMessageContext> nameSpaces;
        if (map.containsKey(element.getName())) {
            nameSpaces = (List)map.get(element.getName());
            result = true;
        } else {
            nameSpaces = new LinkedList();
            map.put(element.getName(), nameSpaces);
            result = false;
        }
        nameSpaces.add(new DefaultMessageContext(String.valueOf(element.getMetaObjectContext().getObjectPakage()) + "." + element.getName()));
        return result;
    }

    private ErrorMessage createErrorMessage(String msg, MessageContextInterface msgContext) {
        return new ErrorMessage(msgContext, msg, -1, -1);
    }

    private List createErrorMessages(String msg, Map map) {
        LinkedList<ErrorMessage> result = new LinkedList<ErrorMessage>();
        for (String name : map.keySet()) {
            List nameSpaces = (List)map.get(name);
            if (nameSpaces.size() <= 1) continue;
            Iterator listIt = nameSpaces.iterator();
            while (listIt.hasNext()) {
                result.add(this.createErrorMessage(msg, (MessageContextInterface)listIt.next()));
            }
        }
        return result;
    }

    private void errorCheck() throws CodegenException {
        LinkedList errors = new LinkedList();
        errors.addAll(this.createErrorMessages("Die Materialbeschreibung wurde mehrfach deklariert.", this.matNames));
        if (errors.size() > 0) {
            CodegenException codegenException = new CodegenException("Fehler bei der Materialnamenpr\u00fcfung.");
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                codegenException.addError((ErrorMessage)it.next());
            }
            throw codegenException;
        }
    }
}

