/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.CLIHandler;
import org.netbeans.core.TimableEventQueue;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class CLIOptions2
extends CLIHandler
implements Runnable {
    private int cnt;
    private static final Logger LOG = Logger.getLogger(CLIOptions2.class.getName());
    private static final int EQ_TIMEOUT = 10000;
    private final RequestProcessor.Task task;
    static CLIOptions2 INSTANCE;

    public CLIOptions2() {
        super(2);
        INSTANCE = this;
        this.task = RequestProcessor.getDefault().create((Runnable)this);
    }

    protected int cli(CLIHandler.Args args) {
        return this.cli(args.getArguments());
    }

    final int cli(String[] stringArray) {
        if (this.cnt++ == 0) {
            return 0;
        }
        LOG.fine("CLI running");
        SwingUtilities.invokeLater(this);
        this.task.schedule(10000);
        return 0;
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            this.eqStuck();
            return;
        }
        LOG.fine("running in EQ");
        this.task.cancel();
        Frame frame = WindowManager.getDefault().getMainWindow();
        frame.setVisible(true);
        if ((frame.getExtendedState() & 1) != 0) {
            frame.setExtendedState(0xFFFFFFFE & frame.getExtendedState());
        }
        frame.toFront();
    }

    private void eqStuck() {
        Thread thread = TimableEventQueue.eq;
        if (thread == null) {
            LOG.warning("event queue thread not determined");
            return;
        }
        LOG.log(Level.FINE, "EQ stuck in {0}", thread);
        LOG.log(Level.WARNING, null, new EQStuck(thread));
        thread.stop();
    }

    protected void usage(PrintWriter printWriter) {
    }

    private static class EQStuck
    extends Throwable {
        EQStuck(Thread thread) {
            super("GUI is not responsive");
            StackTraceElement[] stackTraceElementArray = Thread.getAllStackTraces().get(thread);
            if (stackTraceElementArray != null) {
                this.setStackTrace(stackTraceElementArray);
            } else {
                LOG.log(Level.WARNING, "no stack trace available for {0}", thread);
            }
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

