/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.metadata;

import org.olap4j.metadata.DictionaryImpl;
import org.olap4j.metadata.XmlaConstant;

public class XmlaConstants {
    private XmlaConstants() {
    }

    public static interface EnumWithDesc {
        public String getDescription();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Literal implements XmlaConstant
    {
        CATALOG_NAME(2, null, 24, ".", "0123456789", "A catalog name in a text command."),
        CATALOG_SEPARATOR(3, ".", 0, null, null, null),
        COLUMN_ALIAS(5, null, -1, "'\"[]", "0123456789", null),
        COLUMN_NAME(6, null, -1, ".", "0123456789", null),
        CORRELATION_NAME(7, null, -1, "'\"[]", "0123456789", null),
        CUBE_NAME(21, null, -1, ".", "0123456789", null),
        DIMENSION_NAME(22, null, -1, ".", "0123456789", null),
        HIERARCHY_NAME(23, null, -1, ".", "0123456789", null),
        LEVEL_NAME(24, null, -1, ".", "0123456789", null),
        MEMBER_NAME(25, null, -1, ".", "0123456789", null),
        PROCEDURE_NAME(14, null, -1, ".", "0123456789", null),
        PROPERTY_NAME(26, null, -1, ".", "0123456789", null),
        QUOTE(15, "[", -1, null, null, "The character used in a text command as the opening quote for quoting identifiers that contain special characters."),
        QUOTE_SUFFIX(28, "]", -1, null, null, "The character used in a text command as the closing quote for quoting identifiers that contain special characters. 1.x providers that use the same character as the prefix and suffix may not return this literal value and can set the lt member of the DBLITERAL structure to DBLITERAL_INVALID if requested."),
        TABLE_NAME(17, null, -1, ".", "0123456789", null),
        TEXT_COMMAND(18, null, -1, null, null, "A text command, such as an SQL statement."),
        USER_NAME(19, null, 0, null, null, null);

        private int xmlaOrdinal;
        private final String literalValue;
        private final int literalMaxLength;
        private final String literalInvalidChars;
        private final String literalInvalidStartingChars;
        private final String description;
        private static final XmlaConstant.Dictionary<Literal> DICTIONARY;

        public static XmlaConstant.Dictionary<Literal> getDictionary() {
            return DICTIONARY;
        }

        private Literal(int xmlaOrdinal, String literalValue, int literalMaxLength, String literalInvalidChars, String literalInvalidStartingChars, String description) {
            this.xmlaOrdinal = xmlaOrdinal;
            this.literalValue = literalValue;
            this.literalMaxLength = literalMaxLength;
            this.literalInvalidChars = literalInvalidChars;
            this.literalInvalidStartingChars = literalInvalidStartingChars;
            this.description = description;
        }

        public String getLiteralName() {
            return this.xmlaName();
        }

        public String getLiteralValue() {
            return this.literalValue;
        }

        public String getLiteralInvalidChars() {
            return this.literalInvalidChars;
        }

        public String getLiteralInvalidStartingChars() {
            return this.literalInvalidStartingChars;
        }

        public int getLiteralMaxLength() {
            return this.literalMaxLength;
        }

        @Override
        public String xmlaName() {
            return "DBLITERAL_" + this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(Literal.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StateSupport {
        None,
        Sessions;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MdxSupport {
        Core;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Content {
        None,
        Schema,
        Data,
        SchemaData,
        DataOmitDefaultSlicer,
        DataIncludeDefaultSlicer;

        public static final Content DEFAULT;

        static {
            DEFAULT = SchemaData;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxisFormat implements XmlaConstant
    {
        TupleFormat("The MDDataSet axis is made up of one or more CrossProduct elements."),
        ClusterFormat("Analysis Services uses the TupleFormat format for this setting."),
        CustomFormat("The MDDataSet axis contains one or more Tuple elements.");

        private final String description;
        private static final XmlaConstant.Dictionary<AxisFormat> DICTIONARY;

        public static XmlaConstant.Dictionary<AxisFormat> getDictionary() {
            return DICTIONARY;
        }

        private AxisFormat(String description) {
            this.description = description;
        }

        @Override
        public String xmlaName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return -1;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(AxisFormat.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format implements XmlaConstant
    {
        Tabular("a flat or hierarchical rowset. Similar to the XML RAW format in SQL. The Format property should be set to Tabular for OLE DB for Data Mining commands."),
        Multidimensional("Indicates that the result set will use the MDDataSet format (Execute method only)."),
        Native("The client does not request a specific format, so the provider may return the format  appropriate to the query. (The actual result type is identified by namespace of the result.)");

        private final String description;
        private static final XmlaConstant.Dictionary<Format> DICTIONARY;

        public static XmlaConstant.Dictionary<Format> getDictionary() {
            return DICTIONARY;
        }

        private Format(String description) {
            this.description = description;
        }

        @Override
        public String xmlaName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return -1;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(Format.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DBType
    extends Enum<DBType>
    implements XmlaConstant {
        public static final /* enum */ DBType I4 = new DBType("INTEGER", 3, "DBTYPE_I4", "A four-byte, signed integer: INTEGER");
        public static final /* enum */ DBType R8 = new DBType("DOUBLE", 5, "DBTYPE_R8", "A double-precision floating-point value: Double");
        public static final /* enum */ DBType CY = new DBType("CURRENCY", 6, "DBTYPE_CY", "A currency value: LARGE_INTEGER, Currency is a fixed-point number with four digits to the right of the decimal point. It is stored in an eight-byte signed integer, scaled by 10,000.");
        public static final /* enum */ DBType BOOL = new DBType("BOOLEAN", 11, "DBTYPE_BOOL", "A Boolean value stored in the same way as in Automation: VARIANT_BOOL; 0 means false and ~0 (bitwise, the value is not 0; that is, all bits are set to 1) means true.");
        public static final /* enum */ DBType VARIANT = new DBType("VARIANT", 12, "DBTYPE_VARIANT", "An Automation VARIANT");
        public static final /* enum */ DBType UI2 = new DBType("UNSIGNED_SHORT", 18, "DBTYPE_UI2", "A two-byte, unsigned integer");
        public static final /* enum */ DBType UI4 = new DBType("UNSIGNED_INTEGER", 19, "DBTYPE_UI4", "A four-byte, unsigned integer");
        public static final /* enum */ DBType I8 = new DBType("LARGE_INTEGER", 20, "DBTYPE_I8", "An eight-byte, signed integer: LARGE_INTEGER");
        public static final /* enum */ DBType WSTR = new DBType("STRING", 130, "DBTYPE_WSTR", "A null-terminated Unicode character string: wchar_t[length]; If DBTYPE_WSTR is used by itself, the number of bytes allocated for the string, including the null-termination character, is specified by cbMaxLen in the DBBINDING structure. If DBTYPE_WSTR is combined with DBTYPE_BYREF, the number of bytes allocated for the string, including the null-termination character, is at least the length of the string plus two. In either case, the actual length of the string is determined from the bound length value. The maximum length of the string is the number of allocated bytes divided by sizeof(wchar_t) and truncated to the nearest integer.");
        public final String userName;
        private final int xmlaOrdinal;
        private String description;
        private static final XmlaConstant.Dictionary<DBType> DICTIONARY;
        private static final /* synthetic */ DBType[] $VALUES;

        public static DBType[] values() {
            return (DBType[])$VALUES.clone();
        }

        public static DBType valueOf(String name) {
            return Enum.valueOf(DBType.class, name);
        }

        public static XmlaConstant.Dictionary<DBType> getDictionary() {
            return DICTIONARY;
        }

        private DBType(String userName, int xmlaOrdinal, String dbTypeIndicator, String description) {
            this.userName = userName;
            this.xmlaOrdinal = xmlaOrdinal;
            this.description = description;
            assert (this.xmlaName().equals(dbTypeIndicator));
        }

        @Override
        public String xmlaName() {
            return "DBTYPE_" + this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            $VALUES = new DBType[]{I4, R8, CY, BOOL, VARIANT, UI2, UI4, I8, WSTR};
            DICTIONARY = DictionaryImpl.forClass(DBType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordinateType implements XmlaConstant
    {
        CUBE(1),
        DIMENSION(2),
        LEVEL(3),
        MEMBER(4),
        SET(5),
        CELL(6);

        private final int xmlaOrdinal;
        private static final XmlaConstant.Dictionary<ActionType> DICTIONARY;

        public static XmlaConstant.Dictionary<ActionType> getDictionary() {
            return DICTIONARY;
        }

        private CoordinateType(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        @Override
        public String xmlaName() {
            return "MDACTION_COORDINATE_" + this.name();
        }

        @Override
        public String getDescription() {
            return this.name();
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(ActionType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType implements XmlaConstant
    {
        URL(1),
        HTML(2),
        STATEMENT(4),
        DATASET(8),
        ROWSET(16),
        COMMANDLINE(32),
        PROPRIETARY(64),
        REPORT(128),
        DRILLTHROUGH(256);

        private final int xmlaOrdinal;
        private static final XmlaConstant.Dictionary<ActionType> DICTIONARY;

        public static XmlaConstant.Dictionary<ActionType> getDictionary() {
            return DICTIONARY;
        }

        private ActionType(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        @Override
        public String xmlaName() {
            return "MDACTION_TYPE_" + this.name();
        }

        @Override
        public String getDescription() {
            return this.name();
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(ActionType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontFlag implements XmlaConstant
    {
        BOLD(1),
        ITALIC(2),
        UNDERLINE(4),
        STRIKEOUT(8);

        private final int xmlaOrdinal;
        private static final XmlaConstant.Dictionary<FontFlag> DICTIONARY;

        public static XmlaConstant.Dictionary<FontFlag> getDictionary() {
            return DICTIONARY;
        }

        private FontFlag(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        @Override
        public String xmlaName() {
            return "MDFF_" + this.name();
        }

        @Override
        public String getDescription() {
            return this.name();
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(FontFlag.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Updateable implements XmlaConstant
    {
        MD_MASK_ENABLED(0, "The cell can be updated."),
        MD_MASK_NOT_ENABLED(0x10000000, "The cell cannot be updated."),
        CELL_UPDATE_ENABLED(1, "Cell can be updated in the cellset."),
        CELL_UPDATE_ENABLED_WITH_UPDATE(2, "The cell can be updated with an update statement. The update may fail if a leaf cell is updated that is not write-enabled."),
        CELL_UPDATE_NOT_ENABLED_FORMULA(0x10000001, "The cell cannot be updated because the cell has a calculated member among its coordinates; the cell was retrieved with a set in the where clause. A cell can be updated even though a formula affects, or a calculated cell is on, the value of a cell (is somewhere along the aggregation path). In this scenario, the final value of the cell may not be the updated value, because the calculation will affect the result."),
        CELL_UPDATE_NOT_ENABLED_NONSUM_MEASURE(0x10000002, "The cell cannot be updated because non-sum measures (count, min, max, distinct count, semi-additive) can not be updated."),
        CELL_UPDATE_NOT_ENABLED_NACELL_VIRTUALCUBE(0x10000003, "The cell cannot be updated because the cell does not exist as it is at the intersection of a measure and a dimension member unrelated to the measure\u2019s measure group."),
        CELL_UPDATE_NOT_ENABLED_SECURE(0x10000005, "The cell cannot be updated because the cell is secured."),
        CELL_UPDATE_NOT_ENABLED_CALCLEVEL(0x10000006, "Reserved for future use."),
        CELL_UPDATE_NOT_ENABLED_CANNOTUPDATE(0x10000007, "The cell cannot be updated because of internal reasons."),
        CELL_UPDATE_NOT_ENABLED_INVALIDDIMENSIONTYPE(0x10000009, "The cell cannot be updated because update is not supported in mining model, indirect, or data mining dimensions.");

        private final int xmlaOrdinal;
        private final String description;
        private static final XmlaConstant.Dictionary<Updateable> DICTIONARY;

        public static XmlaConstant.Dictionary<Updateable> getDictionary() {
            return DICTIONARY;
        }

        private Updateable(int xmlaOrdinal, String description) {
            this.xmlaOrdinal = xmlaOrdinal;
            this.description = description;
        }

        @Override
        public String xmlaName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(Updateable.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProviderType implements XmlaConstant
    {
        TDP("tabular data provider."),
        MDP("multidimensional data provider."),
        DMP("data mining provider. A DMP provider implements the OLE DB for Data Mining specification.");

        private final String description;
        private static final DictionaryImpl<ProviderType> DICTIONARY;

        public static XmlaConstant.Dictionary<ProviderType> getDictionary() {
            return DICTIONARY;
        }

        private ProviderType(String description) {
            this.description = description;
        }

        @Override
        public String xmlaName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return -1;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(ProviderType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationMode implements XmlaConstant
    {
        Unauthenticated("no user ID or password needs to be sent."),
        Authenticated("User ID and Password must be included in the information required for the connection."),
        Integrated("the data source uses the underlying security to determine authorization, such as Integrated Security provided by Microsoft Internet Information Services (IIS).");

        private final String description;
        private static final DictionaryImpl<AuthenticationMode> DICTIONARY;

        public static XmlaConstant.Dictionary<AuthenticationMode> getDictionary() {
            return DICTIONARY;
        }

        private AuthenticationMode(String description) {
            this.description = description;
        }

        @Override
        public String xmlaName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return -1;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(AuthenticationMode.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Access implements XmlaConstant
    {
        Read(1),
        Write(2),
        ReadWrite(3);

        private final int xmlaOrdinal;
        private static final DictionaryImpl<Access> DICTIONARY;

        public static XmlaConstant.Dictionary<Access> getDictionary() {
            return DICTIONARY;
        }

        private Access(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        @Override
        public String xmlaName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(Access.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method implements XmlaConstant
    {
        DISCOVER,
        EXECUTE,
        DISCOVER_AND_EXECUTE;

        private static final DictionaryImpl<Method> DICTIONARY;

        public static XmlaConstant.Dictionary<Method> getDictionary() {
            return DICTIONARY;
        }

        @Override
        public String xmlaName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int xmlaOrdinal() {
            return -1;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(Method.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VisualMode implements XmlaConstant
    {
        DEFAULT(0, "Provider-dependent. In Microsoft SQL Server 2000 Analysis Services, this is equivalent to DBPROPVAL_VISUAL_MODE_ORIGINAL."),
        VISUAL(1, "Visual totals are enabled."),
        ORIGINAL(2, "Visual totals are not enabled.");

        private final int xmlaOrdinal;
        private final String description;
        private static final DictionaryImpl<VisualMode> DICTIONARY;

        public static XmlaConstant.Dictionary<VisualMode> getDictionary() {
            return DICTIONARY;
        }

        private VisualMode(int xmlaOrdinal, String description) {
            this.xmlaOrdinal = xmlaOrdinal;
            this.description = description;
        }

        @Override
        public String xmlaName() {
            return "DBPROPVAL_VISUAL_MODE_";
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(VisualMode.class);
        }
    }
}

