/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.olap4j.mdx.MdxUtil;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillThroughNode
implements ParseTreeNode {
    private final ParseRegion region;
    private final SelectNode select;
    private final int maxRowCount;
    private final int firstRowOrdinal;
    private final List<ParseTreeNode> returnList;

    public DrillThroughNode(ParseRegion region, SelectNode select, int maxRowCount, int firstRowOrdinal, List<ParseTreeNode> returnList) {
        this.region = region;
        this.select = select;
        this.maxRowCount = maxRowCount;
        this.firstRowOrdinal = firstRowOrdinal;
        this.returnList = returnList;
    }

    @Override
    public ParseRegion getRegion() {
        return this.region;
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Type getType() {
        return null;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        ParseTreeWriter pw = new ParseTreeWriter(sw);
        this.unparse(pw);
        return sw.toString();
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        PrintWriter pw = writer.getPrintWriter();
        pw.print("DRILLTHROUGH");
        if (this.maxRowCount >= 0) {
            pw.print(" MAXROWS ");
            pw.print(this.maxRowCount);
        }
        if (this.firstRowOrdinal >= 0) {
            pw.print(" FIRSTROWSET ");
            pw.print(this.firstRowOrdinal);
        }
        pw.print(" ");
        this.select.unparse(writer);
        if (this.returnList != null) {
            MdxUtil.unparseList(writer, this.returnList, " RETURN ", ", ", "");
        }
    }

    @Override
    public DrillThroughNode deepCopy() {
        return new DrillThroughNode(this.region, this.select.deepCopy(), this.maxRowCount, this.firstRowOrdinal, MdxUtil.deepCopyList(this.returnList));
    }
}

