/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.core;

import org.apache.commons.javaflow.core.ContinuationDeath;
import org.apache.commons.javaflow.core.ReflectionUtils;
import org.apache.commons.javaflow.core.ResumeParameter;
import org.apache.commons.javaflow.core.Stack;
import org.apache.commons.javaflow.core.SuspendResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StackRecorder
extends Stack {
    private static final Log log = LogFactory.getLog(StackRecorder.class);
    private static final long serialVersionUID = 2L;
    private static final ThreadLocal<StackRecorder> threadMap = new ThreadLocal();
    public transient boolean isRestoring = false;
    public transient boolean isCapturing = false;
    private transient ResumeParameter parameter;
    private transient SuspendResult result;

    public StackRecorder(Runnable target) {
        super(target);
    }

    public StackRecorder(Stack parent) {
        super(parent);
    }

    public static Object suspend(SuspendResult value) {
        log.debug((Object)"suspend()");
        StackRecorder stackRecorder = StackRecorder.get();
        if (stackRecorder == null) {
            throw new IllegalStateException("No continuation is running");
        }
        boolean needCheckExit = stackRecorder.isRestoring;
        stackRecorder.isCapturing = !stackRecorder.isRestoring;
        stackRecorder.isRestoring = false;
        stackRecorder.result = value;
        if (needCheckExit) {
            stackRecorder.parameter.checkExit();
        }
        return stackRecorder.parameter.value();
    }

    public SuspendResult execute(ResumeParameter parameter) {
        if (null == parameter) {
            throw new IllegalArgumentException("ResumeContext parameter may not be null");
        }
        StackRecorder old = this.registerThread();
        try {
            this.isRestoring = !this.isEmpty();
            this.parameter = parameter;
            if (this.isRestoring && log.isDebugEnabled()) {
                log.debug((Object)("Restoring state of " + this.descriptionOf(this.runnable)));
            }
            log.debug((Object)"calling runnable");
            this.runnable.run();
            if (this.isCapturing) {
                if (this.isEmpty()) {
                    throw new IllegalStateException("Stack corruption on suspend (empty stack). Is " + this.descriptionOf(this.runnable) + " instrumented for javaflow?");
                }
                Object ref = this.popReference();
                if (this.runnable != ref) {
                    throw new IllegalStateException("Stack corruption on suspend (invalid reference). Is " + this.descriptionOf(this.runnable.getClass()) + " instrumented for javaflow?");
                }
                SuspendResult suspendResult = this.result;
                return suspendResult;
            }
            if (!this.isEmpty()) {
                throw new IllegalStateException("Stack corruption on exit (non-empty stack). Is " + this.descriptionOf(this.runnable) + " instrumented for javaflow?");
            }
            SuspendResult ref = SuspendResult.EXIT;
            return ref;
        }
        catch (ContinuationDeath cd) {
            SuspendResult suspendResult = SuspendResult.EXIT;
            return suspendResult;
        }
        catch (Error e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.parameter = null;
            this.result = null;
            this.deregisterThread(old);
        }
    }

    public static void exit() {
        throw ContinuationDeath.INSTANCE;
    }

    public Object getContext() {
        return null == this.parameter ? null : this.parameter.value();
    }

    private StackRecorder registerThread() {
        StackRecorder old = StackRecorder.get();
        threadMap.set(this);
        return old;
    }

    private void deregisterThread(StackRecorder old) {
        threadMap.set(old);
    }

    public static StackRecorder get() {
        return threadMap.get();
    }

    private final String descriptionOf(Object object) {
        return ReflectionUtils.getClassName(this.runnable) + "/" + ReflectionUtils.getClassLoaderName(this.runnable);
    }
}

