/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.api;

import java.lang.reflect.Field;
import org.apache.commons.javaflow.core.StackRecorder;

public final class InterceptorSupport {
    private InterceptorSupport() {
    }

    public static boolean isInstrumented(Object target) {
        if (null == target) {
            return false;
        }
        try {
            Field field = target.getClass().getField("___$$$CONT$$$___");
            return (field.getModifiers() & 8) != 0;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    public static Object beforeExecution() {
        StackRecorder stackRecorder = StackRecorder.get();
        if (stackRecorder != null && stackRecorder.isRestoring) {
            return stackRecorder.popReference();
        }
        return null;
    }

    public static void afterExecution(Object interceptor) {
        StackRecorder stackRecorder = StackRecorder.get();
        if (stackRecorder != null && stackRecorder.isCapturing) {
            stackRecorder.pushReference(interceptor);
        }
    }
}

