/*
 * Decompiled with CFR 0.152.
 */
package mondrian.udf;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;
import mondrian.util.Format;

public class CurrentDateMemberUdf
implements UserDefinedFunction {
    private Object resultDateMember = null;

    @Override
    public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
        MatchType matchType;
        if (this.resultDateMember != null) {
            return this.resultDateMember;
        }
        Object formatArg = arguments[1].evaluateScalar(evaluator);
        Locale locale = Locale.getDefault();
        Format format = new Format((String)formatArg, locale);
        String currDateStr = format.format(this.getDate(evaluator, arguments));
        if (arguments.length == 3) {
            String matchStr = arguments[2].evaluateScalar(evaluator).toString();
            matchType = Enum.valueOf(MatchType.class, matchStr);
        } else {
            matchType = MatchType.EXACT;
        }
        List<Id.Segment> uniqueNames = Util.parseIdentifier(currDateStr);
        this.resultDateMember = evaluator.getSchemaReader().getMemberByUniqueName(uniqueNames, false, matchType);
        if (this.resultDateMember != null) {
            return this.resultDateMember;
        }
        Object arg0 = arguments[0].evaluate(evaluator);
        this.resultDateMember = arg0 instanceof Hierarchy ? ((Hierarchy)arg0).getNullMember() : ((Dimension)arg0).getHierarchy().getNullMember();
        return this.resultDateMember;
    }

    Date getDate(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
        return evaluator.getQueryStartTime();
    }

    @Override
    public String getDescription() {
        return "Returns the closest or exact member within the specified dimension corresponding to the current date, in the format specified by the format parameter. Format strings are the same as used by the MDX Format function, namely the Visual Basic format strings. See http://www.apostate.com/programming/vb-format.html.";
    }

    @Override
    public String getName() {
        return "CurrentDateMember";
    }

    @Override
    public Type[] getParameterTypes() {
        return new Type[]{new HierarchyType(null, null), new StringType(), new SymbolType()};
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"EXACT", "BEFORE", "AFTER"};
    }

    @Override
    public Type getReturnType(Type[] parameterTypes) {
        return MemberType.Unknown;
    }

    @Override
    public Syntax getSyntax() {
        return Syntax.Function;
    }
}

