/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SparseSegmentDataset;

public class SegmentWithData
extends Segment {
    final SegmentAxis[] axes;
    private final SegmentDataset data;

    public SegmentWithData(Segment segment, SegmentDataset data, SegmentAxis[] axes) {
        this(segment.getStar(), segment.getConstrainedColumnsBitKey(), segment.getColumns(), segment.measure, segment.predicates, segment.getExcludedRegions(), segment.compoundPredicateList, data, axes);
        if (segment instanceof SegmentWithData) {
            throw new AssertionError();
        }
    }

    private SegmentWithData(RolapStar star, BitKey constrainedColumnsBitKey, RolapStar.Column[] columns, RolapStar.Measure measure, StarColumnPredicate[] predicates, List<Segment.ExcludedRegion> excludedRegions, List<StarPredicate> compoundPredicateList, SegmentDataset data, SegmentAxis[] axes) {
        super(star, constrainedColumnsBitKey, columns, measure, predicates, excludedRegions, compoundPredicateList);
        this.axes = axes;
        this.data = data;
    }

    @Override
    protected void describeAxes(StringBuilder buf, int i, boolean values) {
        super.describeAxes(buf, i, values);
        if (!values) {
            return;
        }
        Comparable[] keys = this.axes[i].getKeys();
        buf.append(", values={");
        for (int j = 0; j < keys.length; ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            Comparable key = keys[j];
            buf.append(key);
        }
        buf.append("}");
    }

    public Object getCellValue(Object[] keys) {
        assert (keys.length == this.axes.length);
        int missed = 0;
        CellKey cellKey = CellKey.Generator.newCellKey(this.axes.length);
        for (int i = 0; i < keys.length; ++i) {
            Comparable key = (Comparable)keys[i];
            int offset = this.axes[i].getOffset(key);
            if (offset < 0) {
                if (this.axes[i].wouldContain(key)) {
                    ++missed;
                    continue;
                }
                return null;
            }
            cellKey.setAxis(i, offset);
        }
        if (this.isExcluded(keys)) {
            return null;
        }
        if (missed > 0) {
            return Util.nullValue;
        }
        Object o = this.data.getObject(cellKey);
        if (o == null) {
            o = Util.nullValue;
        }
        return o;
    }

    boolean wouldContain(Object[] keys) {
        Util.assertTrue(keys.length == this.axes.length);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            if (this.axes[i].wouldContain(key)) continue;
            return false;
        }
        return !this.isExcluded(keys);
    }

    public int getCellCount() {
        int cellCount = 1;
        for (SegmentAxis axis : this.axes) {
            cellCount *= axis.getKeys().length;
        }
        for (Segment.ExcludedRegion excludedRegion : this.excludedRegions) {
            cellCount -= excludedRegion.getCellCount();
        }
        return cellCount;
    }

    SegmentWithData createSubSegment(BitSet[] axisKeepBitSets, int bestColumn, StarColumnPredicate bestPredicate, List<Segment.ExcludedRegion> excludedRegions) {
        assert (axisKeepBitSets.length == this.axes.length);
        SegmentAxis[] newAxes = (SegmentAxis[])this.axes.clone();
        StarColumnPredicate[] newPredicates = (StarColumnPredicate[])this.predicates.clone();
        Map[] axisPosMaps = new Map[this.axes.length];
        int valueCount = 1;
        for (int j = 0; j < this.axes.length; ++j) {
            SegmentAxis newAxis;
            Comparable[] newAxisKeys;
            SegmentAxis axis = this.axes[j];
            StarColumnPredicate newPredicate = axis.getPredicate();
            if (j == bestColumn) {
                newPredicate = bestPredicate;
            }
            Comparable[] axisKeys = axis.getKeys();
            BitSet keepBitSet = axisKeepBitSets[j];
            int firstClearBit = keepBitSet.nextClearBit(0);
            if (firstClearBit >= axisKeys.length) {
                newAxisKeys = axisKeys;
                axisPosMaps[j] = null;
            } else {
                ArrayList<Comparable> newAxisKeyList = new ArrayList<Comparable>();
                HashMap<Integer, Integer> map = axisPosMaps[j] = new HashMap<Integer, Integer>();
                int bit = keepBitSet.nextSetBit(0);
                while (bit >= 0) {
                    map.put(bit, newAxisKeyList.size());
                    newAxisKeyList.add(axisKeys[bit]);
                    bit = keepBitSet.nextSetBit(bit + 1);
                }
                newAxisKeys = newAxisKeyList.toArray(new Comparable[newAxisKeyList.size()]);
                assert (newAxisKeys.length > 0);
            }
            newAxes[j] = newAxis = new SegmentAxis(newPredicate, newAxisKeys);
            newPredicates[j] = newPredicate;
            valueCount *= newAxisKeys.length;
        }
        SegmentDataset newData = this.createDataset(this.axes, this.data instanceof SparseSegmentDataset, this.data.getType(), valueCount);
        int[] pos = new int[this.axes.length];
        block2: for (Map.Entry entry : this.data) {
            CellKey key = (CellKey)entry.getKey();
            for (int i = 0; i < pos.length; ++i) {
                int ordinal = key.getAxis(i);
                Map axisPosMap = axisPosMaps[i];
                if (axisPosMap == null) {
                    pos[i] = ordinal;
                    continue;
                }
                Integer integer = (Integer)axisPosMap.get(ordinal);
                if (integer == null) continue block2;
                pos[i] = integer;
            }
            newData.populateFrom(pos, this.data, key);
        }
        return new SegmentWithData(this.star, this.constrainedColumnsBitKey, this.columns, this.measure, newPredicates, excludedRegions, this.compoundPredicateList, newData, newAxes);
    }

    public final SegmentDataset getData() {
        return this.data;
    }
}

