/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.SQLException;
import java.util.List;
import java.util.RandomAccess;
import mondrian.olap.Member;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.TupleConstraint;

public abstract class TargetBase {
    final List<RolapMember> srcMembers;
    final RolapLevel level;
    private RolapMember currMember;
    private List<RolapMember> list;
    final Object cacheLock;
    final TupleReader.MemberBuilder memberBuilder;

    public TargetBase(List<RolapMember> srcMembers, RolapLevel level, TupleReader.MemberBuilder memberBuilder) {
        this.srcMembers = srcMembers;
        this.level = level;
        this.cacheLock = memberBuilder.getMemberCacheLock();
        this.memberBuilder = memberBuilder;
    }

    public void setList(List<RolapMember> list) {
        assert (list instanceof RandomAccess);
        this.list = list;
    }

    public List<RolapMember> getSrcMembers() {
        return this.srcMembers;
    }

    public RolapLevel getLevel() {
        return this.level;
    }

    public RolapMember getCurrMember() {
        return this.currMember;
    }

    public void removeCurrMember() {
        this.currMember = null;
    }

    public void setCurrMember(RolapMember m) {
        this.currMember = m;
    }

    public List<RolapMember> getList() {
        return this.list;
    }

    public String toString() {
        return this.level.getUniqueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int addRow(SqlStatement stmt, int column) throws SQLException {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.internalAddRow(stmt, column);
        }
    }

    public abstract void open();

    public abstract List<Member> close();

    abstract int internalAddRow(SqlStatement var1, int var2) throws SQLException;

    public void add(RolapMember member) {
        this.getList().add(member);
    }

    RolapNativeCrossJoin.NonEmptyCrossJoinConstraint castToNonEmptyCJConstraint(TupleConstraint constraint) {
        return (RolapNativeCrossJoin.NonEmptyCrossJoinConstraint)constraint;
    }
}

