/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Access;
import mondrian.olap.Formula;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberCacheHelper;
import mondrian.rolap.MemberNoCacheHelper;
import mondrian.rolap.MemberReader;
import mondrian.rolap.NoCacheMemberReader;
import mondrian.rolap.RolapAllCubeMember;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.UnsupportedList;

public class RolapCubeHierarchy
extends RolapHierarchy {
    private final boolean cachingEnabled;
    private final RolapCubeDimension cubeDimension;
    private final RolapHierarchy rolapHierarchy;
    private final RolapCubeLevel currentNullLevel;
    private RolapCubeMember currentNullMember;
    private RolapCubeMember currentAllMember;
    private final MondrianDef.RelationOrJoin currentRelation;
    private final RolapCubeHierarchyMemberReader reader;
    private HierarchyUsage usage;
    private final Map<String, String> aliases;
    private RolapCubeMember currentDefaultMember;
    private final int ordinal;
    protected final boolean usingCubeFact;
    private final int removePrefixLength;
    private final RolapCubeLevel[] cubeLevels;

    public RolapCubeHierarchy(RolapCubeDimension cubeDimension, MondrianDef.CubeDimension cubeDim, RolapHierarchy rolapHierarchy, String subName, int ordinal) {
        super(cubeDimension, subName, RolapCubeHierarchy.applyPrefix(cubeDim, rolapHierarchy.getCaption()), rolapHierarchy.isVisible(), RolapCubeHierarchy.applyPrefix(cubeDim, rolapHierarchy.getDescription()), rolapHierarchy.hasAll(), null, rolapHierarchy.getAnnotationMap());
        this.cachingEnabled = MondrianProperties.instance().EnableRolapCubeMemberCache.get();
        this.aliases = new HashMap<String, String>();
        this.ordinal = ordinal;
        if (!cubeDimension.getCube().isVirtual()) {
            this.usage = new HierarchyUsage(cubeDimension.getCube(), rolapHierarchy, cubeDim);
        }
        this.rolapHierarchy = rolapHierarchy;
        this.cubeDimension = cubeDimension;
        this.xmlHierarchy = rolapHierarchy.getXmlHierarchy();
        this.currentNullLevel = new RolapCubeLevel(this.nullLevel, this);
        boolean bl = this.usingCubeFact = cubeDimension.getCube().getFact() == null || cubeDimension.getCube().getFact().equals((Object)rolapHierarchy.getRelation());
        if (!this.usingCubeFact) {
            assert (this.usage.getJoinExp() instanceof MondrianDef.Column);
            this.currentRelation = this.cubeDimension.getCube().getStar().getUniqueRelation(rolapHierarchy.getRelation(), this.usage.getForeignKey(), ((MondrianDef.Column)this.usage.getJoinExp()).getColumnName(), this.usage.getJoinTable().getAlias());
        } else {
            this.currentRelation = rolapHierarchy.getRelation();
        }
        this.extractNewAliases(rolapHierarchy.getRelation(), this.currentRelation);
        this.relation = this.currentRelation;
        this.cubeLevels = new RolapCubeLevel[rolapHierarchy.getLevels().length];
        this.levels = this.cubeLevels;
        for (int i = 0; i < rolapHierarchy.getLevels().length; ++i) {
            RolapCubeLevel allLevel;
            this.cubeLevels[i] = new RolapCubeLevel((RolapLevel)rolapHierarchy.getLevels()[i], this);
            if (i != 0 || rolapHierarchy.getAllMember() == null) continue;
            if (this.hasAll()) {
                allLevel = this.cubeLevels[0];
            } else {
                allLevel = new RolapCubeLevel(rolapHierarchy.getAllMember().getLevel(), this);
                allLevel.init(cubeDimension.xmlDimension);
            }
            this.currentAllMember = new RolapAllCubeMember(rolapHierarchy.getAllMember(), allLevel);
        }
        this.removePrefixLength = this.uniqueName.equals(rolapHierarchy.getUniqueName()) ? 0 : rolapHierarchy.getUniqueName().length();
        this.reader = cubeDimension.isHighCardinality() || !this.cachingEnabled ? new NoCacheRolapCubeHierarchyMemberReader() : new CacheRolapCubeHierarchyMemberReader();
    }

    private static String applyPrefix(MondrianDef.CubeDimension cubeDim, String caption) {
        if (caption == null) {
            return null;
        }
        if (cubeDim instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage dimensionUsage = (MondrianDef.DimensionUsage)cubeDim;
            if (dimensionUsage.name != null && !dimensionUsage.name.equals(dimensionUsage.source)) {
                if (dimensionUsage.caption != null) {
                    return dimensionUsage.caption + "." + caption;
                }
                return dimensionUsage.name + "." + caption;
            }
        }
        return caption;
    }

    public RolapCubeLevel[] getLevels() {
        return this.cubeLevels;
    }

    @Override
    public String getAllMemberName() {
        return this.rolapHierarchy.getAllMemberName();
    }

    @Override
    public String getSharedHierarchyName() {
        return this.rolapHierarchy.getSharedHierarchyName();
    }

    @Override
    public String getAllLevelName() {
        return this.rolapHierarchy.getAllLevelName();
    }

    public boolean isUsingCubeFact() {
        return this.usingCubeFact;
    }

    public String lookupAlias(String origTable) {
        return this.aliases.get(origTable);
    }

    public final RolapHierarchy getRolapHierarchy() {
        return this.rolapHierarchy;
    }

    @Override
    public final int getOrdinalInCube() {
        return this.ordinal;
    }

    protected void extractNewAliases(MondrianDef.RelationOrJoin oldrel, MondrianDef.RelationOrJoin newrel) {
        if (oldrel == null && newrel == null) {
            return;
        }
        if (oldrel instanceof MondrianDef.Relation && newrel instanceof MondrianDef.Relation) {
            this.aliases.put(((MondrianDef.Relation)oldrel).getAlias(), ((MondrianDef.Relation)newrel).getAlias());
        } else if (oldrel instanceof MondrianDef.Join && newrel instanceof MondrianDef.Join) {
            MondrianDef.Join oldjoin = (MondrianDef.Join)oldrel;
            MondrianDef.Join newjoin = (MondrianDef.Join)newrel;
            this.extractNewAliases(oldjoin.left, newjoin.left);
            this.extractNewAliases(oldjoin.right, newjoin.right);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolapCubeHierarchy)) {
            return false;
        }
        RolapCubeHierarchy that = (RolapCubeHierarchy)o;
        return this.cubeDimension.equals(that.cubeDimension) && this.getUniqueName().equals(that.getUniqueName());
    }

    @Override
    protected int computeHashCode() {
        return Util.hash(super.computeHashCode(), this.cubeDimension.cube);
    }

    @Override
    public Member createMember(Member parent, Level level, String name, Formula formula) {
        RolapLevel rolapLevel = ((RolapCubeLevel)level).getRolapLevel();
        if (formula == null) {
            RolapMember rolapParent = null;
            if (parent != null) {
                rolapParent = ((RolapCubeMember)parent).getRolapMember();
            }
            RolapMemberBase member = new RolapMemberBase(rolapParent, rolapLevel, name);
            return new RolapCubeMember((RolapCubeMember)parent, member, (RolapCubeLevel)level);
        }
        if (level.getDimension().isMeasures()) {
            RolapHierarchy.RolapCalculatedMeasure member = new RolapHierarchy.RolapCalculatedMeasure((RolapMember)parent, rolapLevel, name, formula);
            return new RolapCubeMember((RolapCubeMember)parent, member, (RolapCubeLevel)level);
        }
        RolapCalculatedMember member = new RolapCalculatedMember((RolapMember)parent, rolapLevel, name, formula);
        return new RolapCubeMember((RolapCubeMember)parent, member, (RolapCubeLevel)level);
    }

    @Override
    boolean tableExists(String tableName) {
        return this.rolapHierarchy.tableExists(tableName);
    }

    @Override
    public MondrianDef.RelationOrJoin getRelation() {
        return this.currentRelation;
    }

    @Override
    public final RolapCubeMember getDefaultMember() {
        if (this.currentDefaultMember == null) {
            this.reader.getRootMembers();
            this.currentDefaultMember = this.bootstrapLookup((RolapMember)this.rolapHierarchy.getDefaultMember());
        }
        return this.currentDefaultMember;
    }

    private RolapCubeMember bootstrapLookup(RolapMember rolapMember) {
        RolapCubeMember parent = rolapMember.getParentMember() == null ? null : (rolapMember.getParentMember().isAll() ? this.currentAllMember : this.bootstrapLookup(rolapMember.getParentMember()));
        RolapCubeLevel level = this.cubeLevels[rolapMember.getLevel().getDepth()];
        return this.reader.lookupCubeMember(parent, rolapMember, level);
    }

    @Override
    public Member getNullMember() {
        if (this.currentNullMember == null) {
            this.currentNullMember = new RolapCubeMember(null, (RolapMember)this.rolapHierarchy.getNullMember(), this.currentNullLevel);
        }
        return this.currentNullMember;
    }

    @Override
    public RolapCubeMember getAllMember() {
        return this.currentAllMember;
    }

    @Override
    void setMemberReader(MemberReader memberReader) {
        this.rolapHierarchy.setMemberReader(memberReader);
    }

    @Override
    MemberReader getMemberReader() {
        return this.reader;
    }

    @Override
    public void setDefaultMember(Member defaultMeasure) {
        this.rolapHierarchy.setDefaultMember(defaultMeasure);
        RolapCubeLevel level = new RolapCubeLevel((RolapLevel)this.rolapHierarchy.getDefaultMember().getLevel(), this);
        this.currentDefaultMember = new RolapCubeMember(null, (RolapMember)this.rolapHierarchy.getDefaultMember(), level);
    }

    @Override
    void init(MondrianDef.CubeDimension xmlDimension) {
        this.rolapHierarchy.init(xmlDimension);
        super.init(xmlDimension);
    }

    final String convertMemberName(String memberUniqueName) {
        if (this.removePrefixLength > 0 && !memberUniqueName.startsWith(this.uniqueName)) {
            return this.uniqueName + memberUniqueName.substring(this.removePrefixLength);
        }
        return memberUniqueName;
    }

    public final RolapCube getCube() {
        return this.cubeDimension.cube;
    }

    private static RolapCubeMember createAncestorMembers(RolapCubeHierarchyMemberReader memberReader, RolapCubeLevel level, RolapMember member) {
        if (member == null) {
            return null;
        }
        RolapCubeMember parent = null;
        if (member.getParentMember() != null) {
            parent = RolapCubeHierarchy.createAncestorMembers(memberReader, level.getParentLevel(), member.getParentMember());
        }
        return memberReader.lookupCubeMember(parent, member, level);
    }

    public static class RolapCubeSqlMemberSource
    extends SqlMemberSource {
        private final RolapCubeHierarchyMemberReader memberReader;
        private final MemberCacheHelper memberSourceCacheHelper;
        private final Object memberCacheLock;

        public RolapCubeSqlMemberSource(RolapCubeHierarchyMemberReader memberReader, RolapCubeHierarchy hierarchy, MemberCacheHelper memberSourceCacheHelper, Object memberCacheLock) {
            super(hierarchy);
            this.memberReader = memberReader;
            this.memberSourceCacheHelper = memberSourceCacheHelper;
            this.memberCacheLock = memberCacheLock;
        }

        @Override
        public RolapMember makeMember(RolapMember parentMember, RolapLevel childLevel, Object value, Object captionValue, boolean parentChild, SqlStatement stmt, Object key, int columnOffset) throws SQLException {
            RolapCubeMember parentCubeMember = (RolapCubeMember)parentMember;
            RolapCubeLevel childCubeLevel = (RolapCubeLevel)childLevel;
            RolapMember parent = parentMember != null ? parentCubeMember.getRolapMember() : null;
            RolapMember member = super.makeMember(parent, childCubeLevel.getRolapLevel(), value, captionValue, parentChild, stmt, key, columnOffset);
            return this.memberReader.lookupCubeMember(parentCubeMember, member, childCubeLevel);
        }

        @Override
        public MemberCache getMemberCache() {
            return this.memberSourceCacheHelper;
        }

        @Override
        public Object getMemberCacheLock() {
            return this.memberCacheLock;
        }

        @Override
        public RolapMember allMember() {
            return this.getHierarchy().getAllMember();
        }
    }

    public class NoCacheRolapCubeHierarchyMemberReader
    extends NoCacheMemberReader
    implements RolapCubeHierarchyMemberReader {
        protected final RolapCubeSqlMemberSource cubeSource;
        protected MemberCacheHelper rolapCubeCacheHelper;

        public NoCacheRolapCubeHierarchyMemberReader() {
            super(new SqlMemberSource(RolapCubeHierarchy.this));
            this.rolapCubeCacheHelper = new MemberNoCacheHelper();
            this.cubeSource = new RolapCubeSqlMemberSource(this, RolapCubeHierarchy.this, this.rolapCubeCacheHelper, new MemberNoCacheHelper());
            this.cubeSource.setCache(this.rolapCubeCacheHelper);
        }

        @Override
        public TupleReader.MemberBuilder getMemberBuilder() {
            return this.cubeSource;
        }

        @Override
        public MemberCacheHelper getRolapCubeMemberCacheHelper() {
            return this.rolapCubeCacheHelper;
        }

        @Override
        public List<RolapMember> getRootMembers() {
            return this.getMembersInLevel(RolapCubeHierarchy.this.cubeLevels[0]);
        }

        @Override
        protected void readMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            ArrayList<RolapMember> rolapChildren = new ArrayList<RolapMember>();
            ArrayList<RolapMember> rolapParents = new ArrayList<RolapMember>();
            HashMap<String, RolapCubeMember> lookup = new HashMap<String, RolapCubeMember>();
            List<RolapCubeMember> parentRolapCubeMemberList = Util.cast(parentMembers);
            for (RolapCubeMember member : parentRolapCubeMemberList) {
                RolapMember rolapMember = member.getRolapMember();
                lookup.put(rolapMember.getUniqueName(), member);
                rolapParents.add(rolapMember);
            }
            boolean joinReq = constraint instanceof SqlContextConstraint;
            if (joinReq) {
                super.readMemberChildren(parentMembers, rolapChildren, constraint);
            } else {
                RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberChildren(rolapParents, rolapChildren, constraint);
            }
            for (RolapMember currMember : rolapChildren) {
                RolapCubeMember parent = (RolapCubeMember)lookup.get(currMember.getParentMember().getUniqueName());
                RolapCubeLevel level = parent.getLevel().getChildLevel();
                if (level == null) {
                    level = parent.getLevel();
                }
                RolapCubeMember newmember = this.lookupCubeMember(parent, currMember, level);
                children.add(newmember);
            }
            HashMap tempMap = new HashMap();
            for (RolapMember member1 : parentMembers) {
                tempMap.put(member1, Collections.emptyList());
            }
            for (RolapMember child : children) {
                assert (child != null) : "child";
                RolapMember parentMember = child.getParentMember();
            }
        }

        @Override
        public Map<? extends Member, Access> getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            ArrayList<RolapMember> missed = new ArrayList<RolapMember>();
            for (RolapMember parentMember : parentMembers) {
                if (parentMember.isNull()) continue;
                missed.add(parentMember);
            }
            if (missed.size() > 0) {
                this.readMemberChildren(missed, children, constraint);
            }
            return Util.toNullValuesMap(children);
        }

        @Override
        public List<RolapMember> getMembersInLevel(final RolapLevel level, TupleConstraint constraint) {
            Object members = null;
            boolean joinReq = constraint instanceof SqlContextConstraint;
            final List<RolapMember> list = !joinReq ? RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMembersInLevel(((RolapCubeLevel)level).getRolapLevel(), constraint) : super.getMembersInLevel(level, constraint);
            return new UnsupportedList<RolapMember>(){

                @Override
                public RolapMember get(int index) {
                    return this.mutate((RolapMember)list.get(index));
                }

                @Override
                public int size() {
                    return list.size();
                }

                @Override
                public Iterator<RolapMember> iterator() {
                    final Iterator it = list.iterator();
                    return new Iterator<RolapMember>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public RolapMember next() {
                            return this.mutate((RolapMember)it.next());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                private RolapMember mutate(RolapMember member) {
                    RolapCubeMember parent = null;
                    if (member.getParentMember() != null) {
                        parent = RolapCubeHierarchy.createAncestorMembers(NoCacheRolapCubeHierarchyMemberReader.this, (RolapCubeLevel)level.getParentLevel(), member.getParentMember());
                    }
                    return NoCacheRolapCubeHierarchyMemberReader.this.lookupCubeMember(parent, member, (RolapCubeLevel)level);
                }
            };
        }

        @Override
        public RolapCubeMember lookupCubeMember(RolapCubeMember parent, RolapMember member, RolapCubeLevel level) {
            if (member.getKey() == RolapUtil.sqlNullValue && member.isAll()) {
                return RolapCubeHierarchy.this.getAllMember();
            }
            return new RolapCubeMember(parent, member, level);
        }

        @Override
        public int getMemberCount() {
            return RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberCount();
        }
    }

    public class CacheRolapCubeHierarchyMemberReader
    extends SmartMemberReader
    implements RolapCubeHierarchyMemberReader {
        protected final RolapCubeSqlMemberSource cubeSource;
        protected MemberCacheHelper rolapCubeCacheHelper;
        private final boolean enableCache;

        public CacheRolapCubeHierarchyMemberReader() {
            super(new SqlMemberSource(RolapCubeHierarchy.this));
            this.enableCache = MondrianProperties.instance().EnableRolapCubeMemberCache.get();
            this.rolapCubeCacheHelper = new MemberCacheHelper(RolapCubeHierarchy.this);
            this.cubeSource = new RolapCubeSqlMemberSource(this, RolapCubeHierarchy.this, this.rolapCubeCacheHelper, this.cacheHelper);
            this.cubeSource.setCache(this.getMemberCache());
        }

        @Override
        public TupleReader.MemberBuilder getMemberBuilder() {
            return this.cubeSource;
        }

        @Override
        public MemberCacheHelper getRolapCubeMemberCacheHelper() {
            return this.rolapCubeCacheHelper;
        }

        @Override
        public List<RolapMember> getRootMembers() {
            if (this.rootMembers == null) {
                this.rootMembers = this.getMembersInLevel(RolapCubeHierarchy.this.cubeLevels[0]);
            }
            return this.rootMembers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            ArrayList<RolapMember> rolapChildren = new ArrayList<RolapMember>();
            ArrayList<RolapMember> rolapParents = new ArrayList<RolapMember>();
            HashMap<String, RolapCubeMember> lookup = new HashMap<String, RolapCubeMember>();
            for (RolapMember member : parentMembers) {
                if (member instanceof VisualTotalsFunDef.VisualTotalMember) continue;
                RolapCubeMember cubeMember = (RolapCubeMember)member;
                RolapMember rolapMember = cubeMember.getRolapMember();
                lookup.put(rolapMember.getUniqueName(), cubeMember);
                rolapParents.add(rolapMember);
            }
            boolean joinReq = constraint instanceof SqlContextConstraint;
            if (joinReq) {
                super.readMemberChildren(parentMembers, rolapChildren, constraint);
            } else {
                RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberChildren(rolapParents, rolapChildren, constraint);
            }
            for (RolapMember currMember : rolapChildren) {
                RolapCubeMember parent = (RolapCubeMember)lookup.get(currMember.getParentMember().getUniqueName());
                RolapCubeLevel level = parent.getLevel().getChildLevel();
                if (level == null) {
                    level = parent.getLevel();
                }
                RolapCubeMember newmember = this.lookupCubeMember(parent, currMember, level);
                children.add(newmember);
            }
            HashMap<RolapMember, List<Object>> tempMap = new HashMap<RolapMember, List<Object>>();
            for (RolapMember member1 : parentMembers) {
                tempMap.put(member1, Collections.emptyList());
            }
            for (RolapMember child : children) {
                assert (child != null) : "child";
                RolapMember parentMember = child.getParentMember();
                ArrayList<RolapMember> cacheList = (ArrayList<RolapMember>)tempMap.get(parentMember);
                if (cacheList == null) continue;
                if (cacheList == Collections.EMPTY_LIST) {
                    cacheList = new ArrayList<RolapMember>();
                    tempMap.put(parentMember, cacheList);
                }
                cacheList.add(child);
            }
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                for (Map.Entry entry : tempMap.entrySet()) {
                    RolapMember member = (RolapMember)entry.getKey();
                    if (this.rolapCubeCacheHelper.getChildrenFromCache(member, constraint) != null) continue;
                    List cacheList = (List)entry.getValue();
                    if (!this.enableCache) continue;
                    this.rolapCubeCacheHelper.putChildren(member, constraint, (List<RolapMember>)cacheList);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<? extends Member, Access> getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                this.checkCacheStatus();
                ArrayList<RolapMember> missed = new ArrayList<RolapMember>();
                for (RolapMember parentMember : parentMembers) {
                    List<RolapMember> list = this.rolapCubeCacheHelper.getChildrenFromCache(parentMember, constraint);
                    if (list == null) {
                        if (parentMember.isNull()) continue;
                        missed.add(parentMember);
                        continue;
                    }
                    children.addAll(list);
                }
                if (missed.size() > 0) {
                    this.readMemberChildren(missed, children, constraint);
                }
            }
            return Util.toNullValuesMap(children);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<RolapMember> getMembersInLevel(RolapLevel level, TupleConstraint constraint) {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                this.checkCacheStatus();
                List<RolapMember> members = this.rolapCubeCacheHelper.getLevelMembersFromCache(level, constraint);
                if (members != null) {
                    return members;
                }
                boolean joinReq = constraint instanceof SqlContextConstraint;
                RolapCubeLevel cubeLevel = (RolapCubeLevel)level;
                List<RolapMember> list = !joinReq ? RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMembersInLevel(cubeLevel.getRolapLevel(), constraint) : super.getMembersInLevel(level, constraint);
                ArrayList<RolapMember> newlist = new ArrayList<RolapMember>();
                for (RolapMember member : list) {
                    RolapCubeMember cubeMember = this.lookupCubeMemberWithParent(member, cubeLevel);
                    newlist.add(cubeMember);
                }
                this.rolapCubeCacheHelper.putLevelMembersInCache(level, constraint, newlist);
                return newlist;
            }
        }

        private RolapCubeMember lookupCubeMemberWithParent(RolapMember member, RolapCubeLevel cubeLevel) {
            RolapCubeMember parentCubeMember;
            RolapMember parentMember = member.getParentMember();
            if (parentMember == null) {
                parentCubeMember = null;
            } else {
                RolapCubeLevel parentLevel = parentMember.getLevel() == member.getLevel() ? cubeLevel : cubeLevel.getParentLevel();
                parentCubeMember = this.lookupCubeMemberWithParent(parentMember, parentLevel);
            }
            return this.lookupCubeMember(parentCubeMember, member, cubeLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RolapMember getMemberByKey(RolapLevel level, List<Comparable> keyValues) {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                RolapMember member = super.getMemberByKey(level, keyValues);
                return RolapCubeHierarchy.createAncestorMembers(this, (RolapCubeLevel)level, member);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RolapCubeMember lookupCubeMember(RolapCubeMember parent, RolapMember member, RolapCubeLevel level) {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                RolapCubeMember cubeMember;
                if (member.getKey() == RolapUtil.sqlNullValue && member.isAll()) {
                    return RolapCubeHierarchy.this.getAllMember();
                }
                if (this.enableCache) {
                    Object key = this.rolapCubeCacheHelper.makeKey(parent, member.getKey());
                    cubeMember = (RolapCubeMember)this.rolapCubeCacheHelper.getMember(key, false);
                    if (cubeMember == null) {
                        cubeMember = new RolapCubeMember(parent, member, level);
                        this.rolapCubeCacheHelper.putMember(key, cubeMember);
                    }
                } else {
                    cubeMember = new RolapCubeMember(parent, member, level);
                }
                return cubeMember;
            }
        }

        @Override
        public int getMemberCount() {
            return RolapCubeHierarchy.this.rolapHierarchy.getMemberReader().getMemberCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkCacheStatus() {
            MemberCacheHelper memberCacheHelper = this.cacheHelper;
            synchronized (memberCacheHelper) {
                if (this.cacheHelper.getChangeListener() != null && this.cacheHelper.getChangeListener().isHierarchyChanged(this.getHierarchy())) {
                    SmartMemberReader smartMemberReader;
                    this.cacheHelper.flushCache();
                    this.rolapCubeCacheHelper.flushCache();
                    if (RolapCubeHierarchy.this.rolapHierarchy.getMemberReader() instanceof SmartMemberReader && (smartMemberReader = (SmartMemberReader)RolapCubeHierarchy.this.rolapHierarchy.getMemberReader()).getMemberCache() instanceof MemberCacheHelper) {
                        MemberCacheHelper helper = (MemberCacheHelper)smartMemberReader.getMemberCache();
                        helper.flushCache();
                    }
                }
            }
        }
    }

    public static interface RolapCubeHierarchyMemberReader
    extends MemberReader {
        public RolapCubeMember lookupCubeMember(RolapCubeMember var1, RolapMember var2, RolapCubeLevel var3);

        public MemberCacheHelper getRolapCubeMemberCacheHelper();
    }
}

