/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.Serializable;
import java.util.Arrays;

public interface CellKey
extends Serializable {
    public int size();

    public int[] getOrdinals();

    public void setOrdinals(int[] var1);

    public int getAxis(int var1);

    public void setAxis(int var1, int var2);

    public CellKey copy();

    public int getOffset(int[] var1);

    public static class Many
    implements CellKey {
        private static final long serialVersionUID = 3438398157192694834L;
        private final int[] ordinals;

        protected Many(int[] ordinals) {
            this.ordinals = ordinals;
        }

        @Override
        public final int size() {
            return this.ordinals.length;
        }

        @Override
        public final void setOrdinals(int[] pos) {
            if (this.ordinals.length != pos.length) {
                throw new IllegalArgumentException();
            }
            System.arraycopy(pos, 0, this.ordinals, 0, this.ordinals.length);
        }

        @Override
        public final int[] getOrdinals() {
            return this.ordinals;
        }

        @Override
        public void setAxis(int axis, int value) {
            this.ordinals[axis] = value;
        }

        @Override
        public int getAxis(int axis) {
            return this.ordinals[axis];
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            for (int i = 0; i < this.ordinals.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.ordinals[i]);
            }
            buf.append(')');
            return buf.toString();
        }

        @Override
        public Many copy() {
            return new Many((int[])this.ordinals.clone());
        }

        @Override
        public int getOffset(int[] axisMultipliers) {
            return Generator.getOffset(this.ordinals, axisMultipliers);
        }

        public int hashCode() {
            int h = 17;
            for (int ordinal : this.ordinals) {
                h = h * 37 + ordinal;
            }
            return h;
        }

        public boolean equals(Object o) {
            if (o instanceof Many) {
                Many that = (Many)o;
                return Arrays.equals(this.ordinals, that.ordinals);
            }
            return false;
        }
    }

    public static class Four
    implements CellKey {
        private static final long serialVersionUID = -2645858781233421151L;
        private int ordinal0;
        private int ordinal1;
        private int ordinal2;
        private int ordinal3;

        private Four(int ordinal0, int ordinal1, int ordinal2, int ordinal3) {
            this.ordinal0 = ordinal0;
            this.ordinal1 = ordinal1;
            this.ordinal2 = ordinal2;
            this.ordinal3 = ordinal3;
        }

        public String toString() {
            return "(" + this.ordinal0 + ", " + this.ordinal1 + ", " + this.ordinal2 + ", " + this.ordinal3 + ")";
        }

        @Override
        public Four copy() {
            return new Four(this.ordinal0, this.ordinal1, this.ordinal2, this.ordinal3);
        }

        @Override
        public int getOffset(int[] axisMultipliers) {
            return this.ordinal0 * axisMultipliers[0] + this.ordinal1 * axisMultipliers[1] + this.ordinal2 * axisMultipliers[2] + this.ordinal3;
        }

        public boolean equals(Object o) {
            if (o instanceof Four) {
                Four other = (Four)o;
                return other.ordinal0 == this.ordinal0 && other.ordinal1 == this.ordinal1 && other.ordinal2 == this.ordinal2 && other.ordinal3 == this.ordinal3;
            }
            return false;
        }

        public int hashCode() {
            int h0 = 17 + this.ordinal0;
            int h1 = h0 * 37 + this.ordinal1;
            int h2 = h1 * 37 + this.ordinal2;
            return h2 * 37 + this.ordinal3;
        }

        @Override
        public int getAxis(int axis) {
            switch (axis) {
                case 0: {
                    return this.ordinal0;
                }
                case 1: {
                    return this.ordinal1;
                }
                case 2: {
                    return this.ordinal2;
                }
                case 3: {
                    return this.ordinal3;
                }
            }
            throw new ArrayIndexOutOfBoundsException(axis);
        }

        @Override
        public void setAxis(int axis, int value) {
            switch (axis) {
                case 0: {
                    this.ordinal0 = value;
                    break;
                }
                case 1: {
                    this.ordinal1 = value;
                    break;
                }
                case 2: {
                    this.ordinal2 = value;
                    break;
                }
                case 3: {
                    this.ordinal3 = value;
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException(axis);
                }
            }
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public int[] getOrdinals() {
            return new int[]{this.ordinal0, this.ordinal1, this.ordinal2, this.ordinal3};
        }

        @Override
        public void setOrdinals(int[] pos) {
            if (pos.length != 4) {
                throw new IllegalArgumentException();
            }
            this.ordinal0 = pos[0];
            this.ordinal1 = pos[1];
            this.ordinal2 = pos[2];
            this.ordinal3 = pos[3];
        }
    }

    public static class Three
    implements CellKey {
        private static final long serialVersionUID = -2645858781233421151L;
        private int ordinal0;
        private int ordinal1;
        private int ordinal2;

        private Three(int ordinal0, int ordinal1, int ordinal2) {
            this.ordinal0 = ordinal0;
            this.ordinal1 = ordinal1;
            this.ordinal2 = ordinal2;
        }

        public String toString() {
            return "(" + this.ordinal0 + ", " + this.ordinal1 + ", " + this.ordinal2 + ")";
        }

        @Override
        public Three copy() {
            return new Three(this.ordinal0, this.ordinal1, this.ordinal2);
        }

        @Override
        public int getOffset(int[] axisMultipliers) {
            return this.ordinal0 * axisMultipliers[0] + this.ordinal1 * axisMultipliers[1] + this.ordinal2;
        }

        public boolean equals(Object o) {
            if (o instanceof Three) {
                Three other = (Three)o;
                return other.ordinal0 == this.ordinal0 && other.ordinal1 == this.ordinal1 && other.ordinal2 == this.ordinal2;
            }
            return false;
        }

        public int hashCode() {
            int h0 = 17 + this.ordinal0;
            int h1 = h0 * 37 + this.ordinal1;
            return h1 * 37 + this.ordinal2;
        }

        @Override
        public int getAxis(int axis) {
            switch (axis) {
                case 0: {
                    return this.ordinal0;
                }
                case 1: {
                    return this.ordinal1;
                }
                case 2: {
                    return this.ordinal2;
                }
            }
            throw new ArrayIndexOutOfBoundsException(axis);
        }

        @Override
        public void setAxis(int axis, int value) {
            switch (axis) {
                case 0: {
                    this.ordinal0 = value;
                    break;
                }
                case 1: {
                    this.ordinal1 = value;
                    break;
                }
                case 2: {
                    this.ordinal2 = value;
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException(axis);
                }
            }
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public int[] getOrdinals() {
            return new int[]{this.ordinal0, this.ordinal1, this.ordinal2};
        }

        @Override
        public void setOrdinals(int[] pos) {
            if (pos.length != 3) {
                throw new IllegalArgumentException();
            }
            this.ordinal0 = pos[0];
            this.ordinal1 = pos[1];
            this.ordinal2 = pos[2];
        }
    }

    public static class Two
    implements CellKey {
        private static final long serialVersionUID = 1901188836648369359L;
        private int ordinal0;
        private int ordinal1;

        private Two(int ordinal0, int ordinal1) {
            this.ordinal0 = ordinal0;
            this.ordinal1 = ordinal1;
        }

        public String toString() {
            return "(" + this.ordinal0 + ", " + this.ordinal1 + ")";
        }

        @Override
        public Two copy() {
            return new Two(this.ordinal0, this.ordinal1);
        }

        @Override
        public int getOffset(int[] axisMultipliers) {
            return this.ordinal0 * axisMultipliers[0] + this.ordinal1;
        }

        public boolean equals(Object o) {
            if (o instanceof Two) {
                Two other = (Two)o;
                return other.ordinal0 == this.ordinal0 && other.ordinal1 == this.ordinal1;
            }
            return false;
        }

        public int hashCode() {
            int h0 = 17 + this.ordinal0;
            return h0 * 37 + this.ordinal1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int[] getOrdinals() {
            return new int[]{this.ordinal0, this.ordinal1};
        }

        @Override
        public void setOrdinals(int[] pos) {
            if (pos.length != 2) {
                throw new IllegalArgumentException();
            }
            this.ordinal0 = pos[0];
            this.ordinal1 = pos[1];
        }

        @Override
        public int getAxis(int axis) {
            switch (axis) {
                case 0: {
                    return this.ordinal0;
                }
                case 1: {
                    return this.ordinal1;
                }
            }
            throw new ArrayIndexOutOfBoundsException(axis);
        }

        @Override
        public void setAxis(int axis, int value) {
            switch (axis) {
                case 0: {
                    this.ordinal0 = value;
                    break;
                }
                case 1: {
                    this.ordinal1 = value;
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException(axis);
                }
            }
        }
    }

    public static class One
    implements CellKey {
        private static final long serialVersionUID = 2160238882970820960L;
        private int ordinal0;

        private One(int ordinal0) {
            this.ordinal0 = ordinal0;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int[] getOrdinals() {
            return new int[]{this.ordinal0};
        }

        @Override
        public void setOrdinals(int[] pos) {
            if (pos.length != 1) {
                throw new IllegalArgumentException();
            }
            this.ordinal0 = pos[0];
        }

        @Override
        public int getAxis(int axis) {
            switch (axis) {
                case 0: {
                    return this.ordinal0;
                }
            }
            throw new ArrayIndexOutOfBoundsException(axis);
        }

        @Override
        public void setAxis(int axis, int value) {
            switch (axis) {
                case 0: {
                    this.ordinal0 = value;
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException(axis);
                }
            }
        }

        @Override
        public One copy() {
            return new One(this.ordinal0);
        }

        @Override
        public int getOffset(int[] axisMultipliers) {
            return this.ordinal0;
        }

        public boolean equals(Object o) {
            if (o instanceof One) {
                One other = (One)o;
                return this.ordinal0 == other.ordinal0;
            }
            return false;
        }

        public String toString() {
            return "(" + this.ordinal0 + ")";
        }

        public int hashCode() {
            return 17 + this.ordinal0;
        }
    }

    public static class Zero
    implements CellKey {
        private static final long serialVersionUID = 6063541581473797367L;
        private static final int[] EMPTY_INT_ARRAY = new int[0];
        public static final Zero INSTANCE = new Zero();

        private Zero() {
        }

        @Override
        public Zero copy() {
            return this;
        }

        @Override
        public int getOffset(int[] axisMultipliers) {
            return 0;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return 11;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int[] getOrdinals() {
            return EMPTY_INT_ARRAY;
        }

        @Override
        public void setOrdinals(int[] pos) {
            if (pos.length != 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getAxis(int axis) {
            throw new ArrayIndexOutOfBoundsException(axis);
        }

        @Override
        public void setAxis(int axis, int value) {
            throw new ArrayIndexOutOfBoundsException(axis);
        }
    }

    public static abstract class Generator {
        public static CellKey newCellKey(int size) {
            switch (size) {
                case 0: {
                    return Zero.INSTANCE;
                }
                case 1: {
                    return new One(0);
                }
                case 2: {
                    return new Two(0, 0);
                }
                case 3: {
                    return new Three(0, 0, 0);
                }
                case 4: {
                    return new Four(0, 0, 0, 0);
                }
            }
            return new Many(new int[size]);
        }

        public static CellKey newCellKey(int[] pos) {
            switch (pos.length) {
                case 0: {
                    return Zero.INSTANCE;
                }
                case 1: {
                    return new One(pos[0]);
                }
                case 2: {
                    return new Two(pos[0], pos[1]);
                }
                case 3: {
                    return new Three(pos[0], pos[1], pos[2]);
                }
                case 4: {
                    return new Four(pos[0], pos[1], pos[2], pos[3]);
                }
            }
            return new Many((int[])pos.clone());
        }

        static CellKey newManyCellKey(int size) {
            return new Many(new int[size]);
        }

        public static int getOffset(int[] ordinals, int[] axisMultipliers) {
            int offset = 0;
            for (int i = 0; i < ordinals.length; ++i) {
                offset += ordinals[i] * axisMultipliers[i];
            }
            return offset;
        }
    }
}

