/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class MemberType
implements Type {
    private final Hierarchy hierarchy;
    private final Dimension dimension;
    private final Level level;
    private final Member member;
    private final String digest;
    public static final MemberType Unknown = new MemberType(null, null, null, null);

    public MemberType(Dimension dimension, Hierarchy hierarchy, Level level, Member member) {
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        this.level = level;
        this.member = member;
        if (member != null) {
            Util.assertPrecondition(level != null);
            Util.assertPrecondition(member.getLevel() == level);
        }
        if (level != null) {
            Util.assertPrecondition(hierarchy != null);
            Util.assertPrecondition(level.getHierarchy() == hierarchy);
        }
        if (hierarchy != null) {
            Util.assertPrecondition(dimension != null);
            Util.assertPrecondition(hierarchy.getDimension() == dimension);
        }
        StringBuilder buf = new StringBuilder("MemberType<");
        if (member != null) {
            buf.append("member=").append(member.getUniqueName());
        } else if (level != null) {
            buf.append("level=").append(level.getUniqueName());
        } else if (hierarchy != null) {
            buf.append("hierarchy=").append(hierarchy.getUniqueName());
        } else if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public static MemberType forDimension(Dimension dimension) {
        return new MemberType(dimension, null, null, null);
    }

    public static MemberType forHierarchy(Hierarchy hierarchy) {
        Dimension dimension = hierarchy == null ? null : hierarchy.getDimension();
        return new MemberType(dimension, hierarchy, null, null);
    }

    public static MemberType forLevel(Level level) {
        Hierarchy hierarchy;
        Dimension dimension;
        if (level == null) {
            dimension = null;
            hierarchy = null;
        } else {
            dimension = level.getDimension();
            hierarchy = level.getHierarchy();
        }
        return new MemberType(dimension, hierarchy, level, null);
    }

    public static MemberType forMember(Member member) {
        Level level;
        Hierarchy hierarchy;
        Dimension dimension;
        if (member == null) {
            dimension = null;
            hierarchy = null;
            level = null;
        } else {
            dimension = member.getDimension();
            hierarchy = member.getHierarchy();
            level = member.getLevel();
        }
        return new MemberType(dimension, hierarchy, level, member);
    }

    public String toString() {
        return this.digest;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public boolean usesDimension(Dimension dimension, boolean definitely) {
        return this.dimension == dimension || !definitely && this.dimension == null;
    }

    @Override
    public boolean usesHierarchy(Hierarchy hierarchy, boolean definitely) {
        return this.hierarchy == hierarchy || !definitely && this.hierarchy == null && (this.dimension == null || this.dimension == hierarchy.getDimension());
    }

    public Type getValueType() {
        return new ScalarType();
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    public static MemberType forType(Type type) {
        if (type instanceof MemberType) {
            return (MemberType)type;
        }
        return new MemberType(type.getDimension(), type.getHierarchy(), type.getLevel(), null);
    }

    @Override
    public Type computeCommonType(Type type, int[] conversionCount) {
        if (type instanceof ScalarType) {
            return this.getValueType().computeCommonType(type, conversionCount);
        }
        if (type instanceof TupleType) {
            return type.computeCommonType(this, conversionCount);
        }
        if (!(type instanceof MemberType)) {
            return null;
        }
        MemberType that = (MemberType)type;
        if (this.getMember() != null && this.getMember().equals(that.getMember())) {
            return this;
        }
        if (this.getLevel() != null && this.getLevel().equals(that.getLevel())) {
            return new MemberType(this.getDimension(), this.getHierarchy(), this.getLevel(), null);
        }
        if (this.getHierarchy() != null && this.getHierarchy().equals(that.getHierarchy())) {
            return new MemberType(this.getDimension(), this.getHierarchy(), null, null);
        }
        if (this.getDimension() != null && this.getDimension().equals(that.getDimension())) {
            return new MemberType(this.getDimension(), null, null, null);
        }
        return Unknown;
    }

    @Override
    public boolean isInstance(Object value) {
        return !(!(value instanceof Member) || this.level != null && !((Member)value).getLevel().equals(this.level) || this.hierarchy != null && !((Member)value).getHierarchy().equals(this.hierarchy) || this.dimension != null && !((Member)value).getDimension().equals(this.dimension));
    }

    @Override
    public int getArity() {
        return 1;
    }
}

