/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.VisualTotalsFunDef;

class IntersectFunDef
extends FunDefBase {
    private static final String[] ReservedWords = new String[]{"ALL"};
    static final Resolver resolver = new ReflectiveMultiResolver("Intersect", "Intersect(<Set1>, <Set2>[, ALL])", "Returns the intersection of two input sets, optionally retaining duplicates.", new String[]{"fxxxy", "fxxx"}, IntersectFunDef.class, ReservedWords);

    public IntersectFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        String literalArg = IntersectFunDef.getLiteralArg(call, 2, "", ReservedWords);
        final boolean all = literalArg.equalsIgnoreCase("ALL");
        final int arity = call.getType().getArity();
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleList leftList = listCalc1.evaluateList(evaluator);
                if (leftList.isEmpty()) {
                    return leftList;
                }
                TupleList rightList = listCalc2.evaluateList(evaluator);
                if (rightList.isEmpty()) {
                    return rightList;
                }
                RetrievableHashSet<List> rightSet = new RetrievableHashSet<List>(rightList.size() * 3 / 2);
                for (List tuple : rightList) {
                    rightSet.add(tuple);
                }
                TupleList result = TupleCollections.createList(arity, Math.min(leftList.size(), rightList.size()));
                HashSet<List> resultSet = all ? null : new HashSet<List>();
                for (List leftTuple : leftList) {
                    List rightKey = rightSet.getKey(leftTuple);
                    if (rightKey == null || resultSet != null && !resultSet.add(leftTuple)) continue;
                    result.add(this.copyTupleWithVisualTotalsMembersOverriding(leftTuple, rightKey));
                }
                return result;
            }

            private List<Member> copyTupleWithVisualTotalsMembersOverriding(List<Member> leftTuple, List<Member> rightKey) {
                List<Member> tuple = leftTuple;
                for (int i = 0; i < rightKey.size(); ++i) {
                    Member member = rightKey.get(i);
                    if (tuple.get(i) instanceof VisualTotalsFunDef.VisualTotalMember || !(member instanceof VisualTotalsFunDef.VisualTotalMember)) continue;
                    if (tuple == leftTuple) {
                        tuple = new ArrayList<Member>(leftTuple);
                    }
                    tuple.set(i, member);
                }
                return tuple;
            }
        };
    }

    private static class RetrievableHashSet<E>
    extends HashMap<E, E>
    implements RetrievableSet<E> {
        public RetrievableHashSet(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public E getKey(E e) {
            return (E)super.get(e);
        }

        @Override
        public boolean add(E e) {
            return super.put(e, e) == null;
        }
    }

    private static interface RetrievableSet<E> {
        public E getKey(E var1);

        public boolean add(E var1);
    }
}

