/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import com.bitmechanic.maxq.JTextAreaTestScriptAdapter;
import com.bitmechanic.maxq.ProxyObserver;
import com.bitmechanic.maxq.RequestProcessor;
import com.bitmechanic.maxq.RunTestDialog;
import com.bitmechanic.maxq.Test;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

public class SwingMain
implements ActionListener {
    private JMenuItem newFile = new JMenuItem("New");
    private JMenuItem openFile = new JMenuItem("Open");
    private JMenuItem saveFile = new JMenuItem("Save");
    private JMenuItem saveFileAs = new JMenuItem("Save As");
    private JMenuItem exit = new JMenuItem("Exit");
    private JMenuItem recordTest = new JMenuItem("Record");
    private JMenuItem stopRecordTest = new JMenuItem("Stop Recording");
    private JMenuItem runTest = new JMenuItem("Run");
    private JFrame frame;
    private JMenuBar menuBar;
    private JLabel statusLabel;
    private JScrollPane editorPane;
    private JTextArea textArea;
    private Test currentTest;
    private RequestProcessor requestProcessor;

    public void init() {
        this.frame = new JFrame("MaxQ");
        this.editorPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Courier", 0, 12));
        this.textArea.setLineWrap(false);
        this.editorPane.setViewportView(this.textArea);
        Dimension minimumSize = new Dimension(600, 450);
        this.editorPane.setPreferredSize(minimumSize);
        JPanel statusPane = new JPanel();
        this.statusLabel = new JLabel(" ", 2);
        statusPane.setLayout(new GridLayout(1, 1));
        statusPane.add(this.statusLabel);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
        statusPane.setBorder(border);
        this.frame.getContentPane().add((Component)this.editorPane, "Center");
        this.frame.getContentPane().add((Component)statusPane, "South");
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.newFile);
        fileMenu.add(this.openFile);
        fileMenu.add(this.saveFile);
        fileMenu.add(this.saveFileAs);
        fileMenu.addSeparator();
        fileMenu.add(this.exit);
        JMenu testMenu = new JMenu("Test");
        testMenu.add(this.recordTest);
        testMenu.add(this.stopRecordTest);
        testMenu.add(this.runTest);
        this.newFile.addActionListener(this);
        this.openFile.addActionListener(this);
        this.saveFile.addActionListener(this);
        this.saveFileAs.addActionListener(this);
        this.exit.addActionListener(this);
        this.recordTest.addActionListener(this);
        this.stopRecordTest.addActionListener(this);
        this.runTest.addActionListener(this);
        this.enableMenuItems();
        this.stopRecordTest.setEnabled(false);
        this.menuBar = new JMenuBar();
        this.menuBar.add(fileMenu);
        this.menuBar.add(testMenu);
        this.frame.setJMenuBar(this.menuBar);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
        this.requestProcessor = new RequestProcessor();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.newFile) {
            this.newFile();
        }
        if (source == this.openFile) {
            this.openFile();
        } else if (source == this.saveFile) {
            try {
                this.saveFile();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (source == this.saveFileAs) {
            try {
                this.saveFileAs();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (source == this.runTest) {
            this.runTest();
        } else if (source == this.recordTest) {
            this.recordTest();
        } else if (source == this.stopRecordTest) {
            this.stopRecordTest();
        } else if (source == this.exit) {
            System.exit(0);
        }
    }

    private void enableMenuItems() {
        boolean enable = this.currentTest != null;
        this.saveFile.setEnabled(enable);
        this.saveFileAs.setEnabled(enable);
        this.recordTest.setEnabled(enable);
        this.runTest.setEnabled(enable);
    }

    private void newFile() {
        this.currentTest = new Test(new JTextAreaTestScriptAdapter(this.textArea));
        this.recordTest.setEnabled(true);
        this.saveFile.setEnabled(true);
        this.saveFileAs.setEnabled(false);
        this.runTest.setEnabled(true);
    }

    public String getCurrentPath() {
        String currentPath = null;
        currentPath = this.currentTest == null ? System.getProperty("user.dir") : this.currentTest.getCurrentPath();
        return currentPath;
    }

    private void openFile() {
        JFileChooser fc = new JFileChooser(this.getCurrentPath());
        int returnVal = fc.showOpenDialog(this.frame);
        if (returnVal == 0) {
            try {
                this.currentTest = new Test(new JTextAreaTestScriptAdapter(this.textArea));
                this.currentTest.openTest(fc.getSelectedFile());
                this.requestProcessor.addObserver(this.currentTest);
                this.enableMenuItems();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveFile() throws IOException {
        this.currentTest.save();
        this.saveFileAs.setEnabled(true);
    }

    private void saveFileAs() throws IOException {
        JFileChooser fc = new JFileChooser(this.currentTest.getCurrentPath());
        int returnVal = fc.showOpenDialog(this.frame);
        if (returnVal == 0) {
            this.currentTest.setTestFile(fc.getSelectedFile());
            this.saveFile();
        }
    }

    private void recordTest() {
        this.setStatus("Recording Test");
        this.requestProcessor.addObserver(this.currentTest);
        this.stopRecordTest.setEnabled(true);
        this.recordTest.setEnabled(false);
        this.saveFile.setEnabled(false);
        this.saveFileAs.setEnabled(false);
        this.runTest.setEnabled(false);
        this.openFile.setEnabled(false);
        this.newFile.setEnabled(false);
        this.currentTest.startRecording();
    }

    private void stopRecordTest() {
        JFileChooser fc;
        int returnVal;
        if (this.currentTest.getTestFile() == null && (returnVal = (fc = new JFileChooser(this.currentTest.getCurrentPath())).showOpenDialog(this.frame)) == 0) {
            this.currentTest.setTestFile(fc.getSelectedFile());
        }
        if (this.currentTest.getTestFile() != null) {
            try {
                this.currentTest.stopRecording();
                this.requestProcessor.removeObserver(this.currentTest);
                this.saveFile();
                this.stopRecordTest.setEnabled(false);
                this.recordTest.setEnabled(true);
                this.runTest.setEnabled(true);
                this.setStatus("");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void runTest() {
        this.setStatus("Running Test");
        RunTestDialog runner = new RunTestDialog(this.frame, this.currentTest.getTestScript());
        this.setStatus("");
    }

    private void setStatus(String status) {
        if (status == null || status.length() < 1) {
            status = " ";
        }
        this.statusLabel.setText(status);
    }

    public ProxyObserver getRequestProcessor() {
        return this.requestProcessor;
    }
}

