/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.sequence.RecursiveSequence;

public class NormalizeArrayFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "NORMALIZEARRAY";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Boolean removeNullValuesRaw;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0 || parameterCount > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Sequence sequenceRaw = context.getTypeRegistry().convertToSequence(parameters.getType(0), parameters.getValue(0));
        if (sequenceRaw == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        RecursiveSequence sequence = new RecursiveSequence(sequenceRaw, context);
        boolean removeNull = parameterCount == 2 ? (removeNullValuesRaw = context.getTypeRegistry().convertToLogical(parameters.getType(1), parameters.getValue(1))) == null || Boolean.TRUE.equals(removeNullValuesRaw) : true;
        ArrayList<Object> retval = new ArrayList<Object>();
        while (sequence.hasNext()) {
            Object o = sequence.next();
            if (removeNull && o == null) continue;
            retval.add(o);
        }
        return new TypeValuePair(AnyType.ANY_ARRAY, retval.toArray());
    }
}

