/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ProperFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "PROPER";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        String result = context.getTypeRegistry().convertToText(type1, value1);
        if (result == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(TextType.TYPE, this.capitalize(result));
    }

    private String capitalize(String text) {
        char[] textArray = text.toCharArray();
        boolean startOfWord = true;
        int textLength = textArray.length;
        for (int i = 0; i < textLength; ++i) {
            char c = textArray[i];
            if (!Character.isLetter(c)) {
                startOfWord = true;
                continue;
            }
            if (startOfWord && Character.isLetter(c)) {
                textArray[i] = Character.toTitleCase(c);
            }
            startOfWord = false;
        }
        return new String(textArray);
    }
}

