/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.util.HashMap;
import org.pentaho.reporting.libraries.base.boot.ObjectFactory;
import org.pentaho.reporting.libraries.base.boot.ObjectFactoryException;
import org.pentaho.reporting.libraries.base.boot.SingletonHint;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DefaultObjectFactory
implements ObjectFactory {
    private Configuration configuration;
    private HashMap<String, Object> singletons;

    public DefaultObjectFactory(Configuration configuration) {
        this.configuration = configuration;
        this.singletons = new HashMap();
    }

    @Override
    public <T> T get(Class<T> interfaceClass) {
        return this.get(interfaceClass, interfaceClass.getName());
    }

    @Override
    public synchronized <T> T get(Class<T> interfaceClass, String key) {
        String value = this.configuration.getConfigProperty(key);
        if (value == null) {
            throw new ObjectFactoryException(interfaceClass.getName(), value);
        }
        try {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(interfaceClass);
            Class<?> clazz = Class.forName(value, false, classLoader);
            SingletonHint annotation = clazz.getAnnotation(SingletonHint.class);
            if (annotation == null) {
                T retval = ObjectUtilities.loadAndInstantiate(value, interfaceClass, interfaceClass);
                if (retval == null) {
                    throw new ObjectFactoryException(interfaceClass.getName(), value);
                }
                return retval;
            }
            Object o = this.singletons.get(value);
            if (o != null) {
                return (T)o;
            }
            T retval = ObjectUtilities.loadAndInstantiate(value, interfaceClass, interfaceClass);
            if (retval == null) {
                throw new ObjectFactoryException(interfaceClass.getName(), value);
            }
            this.singletons.put(value, retval);
            return retval;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

