/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.writetolog;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.writetolog.WriteToLogData;
import org.pentaho.di.trans.steps.writetolog.WriteToLogMeta;

public class WriteToLog
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = WriteToLogMeta.class;
    private WriteToLogMeta meta;
    private WriteToLogData data;
    private int rowCounter = 0;
    private boolean rowCounterLimitHit = false;

    public WriteToLog(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (WriteToLogMeta)smi;
        this.data = (WriteToLogData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.rowCounterLimitHit) {
            this.putRow(this.getInputRowMeta(), r);
            return true;
        }
        if (this.first) {
            int i;
            this.first = false;
            if (this.meta.getFieldName() != null && this.meta.getFieldName().length > 0) {
                this.data.fieldnrs = new int[this.meta.getFieldName().length];
                for (i = 0; i < this.data.fieldnrs.length; ++i) {
                    this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldName()[i]);
                    if (this.data.fieldnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"WriteToLog.Log.CanNotFindField", (String[])new String[]{this.meta.getFieldName()[i]}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"WriteToLog.Log.CanNotFindField", (String[])new String[]{this.meta.getFieldName()[i]}));
                }
            } else {
                this.data.fieldnrs = new int[this.getInputRowMeta().size()];
                for (i = 0; i < this.data.fieldnrs.length; ++i) {
                    this.data.fieldnrs[i] = i;
                }
            }
            this.data.fieldnr = this.data.fieldnrs.length;
            this.data.loglevel = this.meta.getLogLevelByDesc();
            this.data.logmessage = Const.NVL((String)this.environmentSubstitute(this.meta.getLogMessage()), (String)"");
            if (!Const.isEmpty((String)this.data.logmessage)) {
                this.data.logmessage = this.data.logmessage + Const.CR + Const.CR;
            }
        }
        StringBuffer out = new StringBuffer();
        out.append(Const.CR + "------------> " + BaseMessages.getString(PKG, (String)"WriteToLog.Log.NLigne", (String[])new String[]{"" + this.getLinesRead()}) + "------------------------------" + Const.CR);
        out.append(this.getRealLogMessage());
        for (int i = 0; i < this.data.fieldnr; ++i) {
            String fieldvalue = this.getInputRowMeta().getString(r, this.data.fieldnrs[i]);
            if (this.meta.isdisplayHeader()) {
                String fieldname = this.getInputRowMeta().getFieldNames()[this.data.fieldnrs[i]];
                out.append(fieldname + " = " + fieldvalue + Const.CR);
                continue;
            }
            out.append(fieldvalue + Const.CR);
        }
        out.append(Const.CR + "====================");
        this.setLog(this.data.loglevel, out);
        if (this.meta.isLimitRows() && ++this.rowCounter >= this.meta.getLimitRowsNumber()) {
            this.rowCounterLimitHit = true;
        }
        this.putRow(this.getInputRowMeta(), r);
        return true;
    }

    private void setLog(LogLevel loglevel, StringBuffer msg) {
        switch (loglevel) {
            case ERROR: {
                this.logError(msg.toString());
                break;
            }
            case MINIMAL: {
                this.logMinimal(msg.toString());
                break;
            }
            case BASIC: {
                this.logBasic(msg.toString());
                break;
            }
            case DETAILED: {
                this.logDetailed(msg.toString());
                break;
            }
            case DEBUG: {
                this.logDebug(msg.toString());
                break;
            }
            case ROWLEVEL: {
                this.logRowlevel(msg.toString());
                break;
            }
            case NOTHING: {
                break;
            }
        }
    }

    public String getRealLogMessage() {
        return this.data.logmessage;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WriteToLogMeta)smi;
        this.data = (WriteToLogData)sdi;
        return super.init(smi, sdi);
    }
}

