/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.w3c.dom.Node;

public class SelectMetadataChange
implements Cloneable,
XMLInterface {
    public static final String XML_TAG = "meta";
    private String name;
    private String rename;
    private int type;
    private int length;
    private int precision;
    private int storageType;
    private String conversionMask;
    private boolean dateFormatLenient;
    private String dateFormatLocale;
    private String dateFormatTimeZone;
    private boolean lenientStringToNumber;
    private String decimalSymbol;
    private String groupingSymbol;
    private String currencySymbol;
    private String encoding;
    private StepAttributesInterface attributesInterface;

    public SelectMetadataChange(StepAttributesInterface attributesInterface) {
        this.attributesInterface = attributesInterface;
        this.storageType = -1;
    }

    public SelectMetadataChange(StepAttributesInterface attributesInterface, String name, String rename, int type, int length, int precision, int storageType, String conversionMask, String decimalSymbol, String groupingSymbol, String currencySymbol) {
        this(attributesInterface, name, rename, type, length, precision, storageType, conversionMask, false, null, null, false, decimalSymbol, groupingSymbol, currencySymbol);
    }

    public SelectMetadataChange(StepAttributesInterface attributesInterface, String name, String rename, int type, int length, int precision, int storageType, String conversionMask, boolean dateFormatLenient, String dateFormatLocale, String dateFormatTimeZone, boolean lenientStringToNumber, String decimalSymbol, String groupingSymbol, String currencySymbol) {
        this(attributesInterface);
        this.name = name;
        this.rename = rename;
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.storageType = storageType;
        this.conversionMask = conversionMask;
        this.dateFormatLenient = dateFormatLenient;
        this.dateFormatLocale = dateFormatLocale;
        this.dateFormatTimeZone = dateFormatTimeZone;
        this.lenientStringToNumber = lenientStringToNumber;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.currencySymbol = currencySymbol;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      ").append(XMLHandler.openTag((String)XML_TAG));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_NAME"), (String)this.name));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_RENAME"), (String)this.rename));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_TYPE"), (String)ValueMeta.getTypeDesc((int)this.type)));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_LENGTH"), (int)this.length));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_PRECISION"), (int)this.precision));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_CONVERSION_MASK"), (String)this.conversionMask));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_DATE_FORMAT_LENIENT"), (String)Boolean.toString(this.dateFormatLenient)));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_DATE_FORMAT_LOCALE"), (String)this.dateFormatLocale));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_DATE_FORMAT_TIMEZONE"), (String)this.dateFormatTimeZone));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_LENIENT_STRING_TO_NUMBER"), (String)Boolean.toString(this.lenientStringToNumber)));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_ENCODING"), (String)this.encoding));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_DECIMAL"), (String)this.decimalSymbol));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_GROUPING"), (String)this.groupingSymbol));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_CURRENCY"), (String)this.currencySymbol));
        retval.append("        ").append(XMLHandler.addTagValue((String)this.attributesInterface.getXmlCode("META_STORAGE_TYPE"), (String)ValueMeta.getStorageTypeCode((int)this.storageType)));
        retval.append("      ").append(XMLHandler.closeTag((String)XML_TAG));
        return retval.toString();
    }

    public void loadXML(Node metaNode) {
        this.name = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_NAME"));
        this.rename = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_RENAME"));
        this.type = ValueMeta.getType((String)XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_TYPE")));
        this.length = Const.toInt((String)XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_LENGTH")), (int)-2);
        this.precision = Const.toInt((String)XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_PRECISION")), (int)-2);
        this.storageType = ValueMeta.getStorageType((String)XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_STORAGE_TYPE")));
        this.conversionMask = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_CONVERSION_MASK"));
        this.dateFormatLenient = Boolean.parseBoolean(XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_DATE_FORMAT_LENIENT")));
        this.dateFormatLocale = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_DATE_FORMAT_LOCALE"));
        this.dateFormatTimeZone = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_DATE_FORMAT_TIMEZONE"));
        this.encoding = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_ENCODING"));
        this.lenientStringToNumber = Boolean.parseBoolean(XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_LENIENT_STRING_TO_NUMBER")));
        this.encoding = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_ENCODING"));
        this.decimalSymbol = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_DECIMAL"));
        this.groupingSymbol = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_GROUPING"));
        this.currencySymbol = XMLHandler.getTagValue((Node)metaNode, (String)this.attributesInterface.getXmlCode("META_CURRENCY"));
    }

    public SelectMetadataChange clone() {
        try {
            return (SelectMetadataChange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public boolean isDateFormatLenient() {
        return this.dateFormatLenient;
    }

    public void setDateFormatLenient(boolean dateFormatLenient) {
        this.dateFormatLenient = dateFormatLenient;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isLenientStringToNumber() {
        return this.lenientStringToNumber;
    }

    public void setLenientStringToNumber(boolean lenientStringToNumber) {
        this.lenientStringToNumber = lenientStringToNumber;
    }

    public String getDateFormatLocale() {
        return this.dateFormatLocale;
    }

    public void setDateFormatLocale(String dateFormatLocale) {
        this.dateFormatLocale = dateFormatLocale;
    }

    public String getDateFormatTimeZone() {
        return this.dateFormatTimeZone;
    }

    public void setDateFormatTimeZone(String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
    }
}

