/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.prioritizestreams;

import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreamsData;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreamsMeta;

public class PrioritizeStreams
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PrioritizeStreamsMeta.class;
    private PrioritizeStreamsMeta meta;
    private PrioritizeStreamsData data;

    public PrioritizeStreams(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PrioritizeStreamsMeta)smi;
        this.data = (PrioritizeStreamsData)sdi;
        if (this.first) {
            if (this.meta.getStepName() != null || this.meta.getStepName().length > 0) {
                this.data.stepnrs = this.meta.getStepName().length;
                this.data.rowSets = new RowSet[this.data.stepnrs];
                for (int i = 0; i < this.data.stepnrs; ++i) {
                    this.data.rowSets[i] = this.findInputRowSet(this.meta.getStepName()[i]);
                    if (i <= 0) continue;
                    this.checkInputLayoutValid(this.data.rowSets[0].getRowMeta(), this.data.rowSets[i].getRowMeta());
                }
            } else {
                throw new KettleException(BaseMessages.getString(PKG, (String)"PrioritizeStreams.Error.NotInputSteps", (String[])new String[0]));
            }
            this.data.currentRowSet = this.data.rowSets[0];
        }
        Object[] input = this.getOneRow();
        while (input == null && this.data.stepnr < this.data.stepnrs - 1 && !this.isStopped()) {
            input = this.getOneRow();
        }
        if (input == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.outputRowMeta = this.data.currentRowSet.getRowMeta();
            this.first = false;
        }
        this.putRow(this.data.outputRowMeta, input);
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        Object[] input = this.getRowFrom(this.data.currentRowSet);
        if (input == null && this.data.stepnr < this.data.stepnrs - 1) {
            ++this.data.stepnr;
            this.data.currentRowSet = this.data.rowSets[this.data.stepnr];
            input = this.getRowFrom(this.data.currentRowSet);
        }
        return input;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PrioritizeStreamsMeta)smi;
        this.data = (PrioritizeStreamsData)sdi;
        if (super.init(smi, sdi)) {
            this.data.stepnr = 0;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.currentRowSet = null;
        this.data.rowSets = null;
        super.dispose(smi, sdi);
    }

    protected void checkInputLayoutValid(RowMetaInterface referenceRowMeta, RowMetaInterface compareRowMeta) throws KettleRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseStep.safeModeChecking(referenceRowMeta, compareRowMeta);
        }
    }
}

