/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.numberrange;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.numberrange.NumberRangeData;
import org.pentaho.di.trans.steps.numberrange.NumberRangeMeta;
import org.pentaho.di.trans.steps.numberrange.NumberRangeSet;

public class NumberRange
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = NumberRangeMeta.class;
    private NumberRangeData data;
    private NumberRangeMeta meta;
    private NumberRangeSet numberRange;

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block7: {
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.numberRange = new NumberRangeSet(this.meta.getRules(), this.meta.getFallBackValue());
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.inputColumnNr = this.data.outputRowMeta.indexOfValue(this.meta.getInputField());
                if (this.data.inputColumnNr < 0) {
                    this.logError("Field for input could not be found: " + this.meta.getInputField());
                    return false;
                }
            }
            try {
                Double value = this.getInputRowMeta().getNumber(row, this.data.inputColumnNr);
                String ranges = this.numberRange.evaluate(value);
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])new Object[]{ranges});
                this.putRow(this.data.outputRowMeta, row);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"NumberRange.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"NumberRange.Log.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "NumberRange001");
            }
        }
        return true;
    }

    public NumberRange(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NumberRangeMeta)smi;
        this.data = (NumberRangeData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NumberRangeMeta)smi;
        this.data = (NumberRangeData)sdi;
        super.dispose(smi, sdi);
    }
}

