/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapoutput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocolFactory;
import org.pentaho.di.trans.steps.ldapoutput.LDAPOutput;
import org.pentaho.di.trans.steps.ldapoutput.LDAPOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class LDAPOutputMeta
extends BaseStepMeta
implements LdapMeta {
    private static Class<?> PKG = LDAPOutputMeta.class;
    private boolean useAuthentication;
    private String Host;
    private String userName;
    private String password;
    private String port;
    private String dnFieldName;
    private boolean failIfNotExist;
    private String[] updateLookup;
    private String[] updateStream;
    private Boolean[] update;
    private String searchBase;
    private String multiValuedSeparator;
    private int operationType;
    private String oldDnFieldName;
    private String newDnFieldName;
    private boolean deleteRDN;
    public static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LDAPOutputMeta.operationType.Insert", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.operationType.Upsert", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.operationType.Update", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.operationType.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.operationType.Delete", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.operationType.Rename", (String[])new String[0])};
    public static final String[] operationTypeCode = new String[]{"insert", "upsert", "update", "add", "delete", "rename"};
    public static final int OPERATION_TYPE_INSERT = 0;
    public static final int OPERATION_TYPE_UPSERT = 1;
    public static final int OPERATION_TYPE_UPDATE = 2;
    public static final int OPERATION_TYPE_ADD = 3;
    public static final int OPERATION_TYPE_DELETE = 4;
    public static final int OPERATION_TYPE_RENAME = 5;
    private int referralType;
    public static final String[] referralTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LDAPOutputMeta.referralType.Follow", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.referralType.Ignore", (String[])new String[0])};
    public static final String[] referralTypeCode = new String[]{"follow", "ignore"};
    public static final int REFERRAL_TYPE_FOLLOW = 0;
    public static final int REFERRAL_TYPE_IGNORE = 1;
    private int derefAliasesType;
    public static final String[] derefAliasesTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"LDAPOutputMeta.derefAliasesType.Always", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.derefAliasesType.Never", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.derefAliasesType.Searching", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPOutputMeta.derefAliasesType.Finding", (String[])new String[0])};
    public static final String[] derefAliasesTypeCode = new String[]{"always", "never", "searching", "finding"};
    public static final int DEREFALIASES_TYPE_ALWAYS = 0;
    public static final int DEREFALIASES_TYPE_NEVER = 1;
    public static final int DEREFALIASES_TYPE_SEARCHING = 2;
    public static final int DEREFALIASES_TYPE_FINDING = 3;
    private String protocol;
    private boolean useCertificate;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean trustAllCertificates;

    @Override
    public boolean isUseCertificate() {
        return this.useCertificate;
    }

    public void setUseCertificate(boolean value) {
        this.useCertificate = value;
    }

    @Override
    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean value) {
        this.trustAllCertificates = value;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String value) {
        this.trustStorePassword = value;
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String value) {
        this.trustStorePath = value;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String value) {
        this.protocol = value;
    }

    public Boolean[] getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean[] update) {
        this.update = update;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public int getReferralType() {
        return this.referralType;
    }

    public int getDerefAliasesType() {
        return this.derefAliasesType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LDAPOutputMeta.getOperationTypeByCode(tt);
    }

    public static int getReferralTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < referralTypeDesc.length; ++i) {
            if (!referralTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LDAPOutputMeta.getReferralTypeByCode(tt);
    }

    public static int getDerefAliasesTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < derefAliasesTypeDesc.length; ++i) {
            if (!derefAliasesTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LDAPOutputMeta.getReferralTypeByCode(tt);
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getReferralTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < referralTypeCode.length; ++i) {
            if (!referralTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getDerefAliasesTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < derefAliasesTypeCode.length; ++i) {
            if (!derefAliasesTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public void setReferralType(int value) {
        this.referralType = value;
    }

    public void setDerefAliasesType(int value) {
        this.derefAliasesType = value;
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    public static String getReferralTypeDesc(int i) {
        if (i < 0 || i >= referralTypeDesc.length) {
            return referralTypeDesc[0];
        }
        return referralTypeDesc[i];
    }

    public static String getDerefAliasesTypeDesc(int i) {
        if (i < 0 || i >= derefAliasesTypeDesc.length) {
            return derefAliasesTypeDesc[0];
        }
        return derefAliasesTypeDesc[i];
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public boolean UseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    @Override
    public String getHost() {
        return this.Host;
    }

    public void setHost(String host) {
        this.Host = host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDnField(String value) {
        this.dnFieldName = value;
    }

    public String getDnField() {
        return this.dnFieldName;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isFailIfNotExist() {
        return this.failIfNotExist;
    }

    public void setFailIfNotExist(boolean value) {
        this.failIfNotExist = value;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        LDAPOutputMeta retval = (LDAPOutputMeta)super.clone();
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.updateLookup[i] = this.updateLookup[i];
            retval.updateStream[i] = this.updateStream[i];
            retval.update[i] = this.update[i];
        }
        return retval;
    }

    public void setDeleteRDN(boolean value) {
        this.deleteRDN = value;
    }

    public boolean isDeleteRDN() {
        return this.deleteRDN;
    }

    public void setNewDnFieldName(String value) {
        this.newDnFieldName = value;
    }

    public String getNewDnFieldName() {
        return this.newDnFieldName;
    }

    public void setOldDnFieldName(String value) {
        this.oldDnFieldName = value;
    }

    public String getOldDnFieldName() {
        return this.oldDnFieldName;
    }

    public void setSearchBaseDN(String searchBase) {
        this.searchBase = searchBase;
    }

    public String getSearchBaseDN() {
        return this.searchBase;
    }

    public void setMultiValuedSeparator(String multiValuedSeparator) {
        this.multiValuedSeparator = multiValuedSeparator;
    }

    public String getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    public void allocate(int nrvalues) {
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
        this.update = new Boolean[nrvalues];
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    public static String getReferralTypeCode(int i) {
        if (i < 0 || i >= referralTypeCode.length) {
            return referralTypeCode[0];
        }
        return referralTypeCode[i];
    }

    public static String getDerefAliasesCode(int i) {
        if (i < 0 || i >= derefAliasesTypeCode.length) {
            return derefAliasesTypeCode[0];
        }
        return derefAliasesTypeCode[i];
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"useauthentication", (boolean)this.useAuthentication));
        retval.append("    ").append(XMLHandler.addTagValue((String)"host", (String)this.Host));
        retval.append("    ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dnFieldName", (String)this.dnFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"failIfNotExist", (boolean)this.failIfNotExist));
        retval.append("    ").append(XMLHandler.addTagValue((String)"operationType", (String)LDAPOutputMeta.getOperationTypeCode(this.operationType)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"multivaluedseparator", (String)this.multiValuedSeparator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"searchBase", (String)this.searchBase));
        retval.append("    ").append(XMLHandler.addTagValue((String)"referralType", (String)LDAPOutputMeta.getReferralTypeCode(this.referralType)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"derefAliasesType", (String)LDAPOutputMeta.getDerefAliasesCode(this.derefAliasesType)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"oldDnFieldName", (String)this.oldDnFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"newDnFieldName", (String)this.newDnFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"deleteRDN", (boolean)this.deleteRDN));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.updateStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"update", (boolean)this.update[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trustStorePath", (String)this.trustStorePath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trustStorePassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.trustStorePassword)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trustAllCertificates", (boolean)this.trustAllCertificates));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useCertificate", (boolean)this.useCertificate));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.useAuthentication = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useauthentication"));
            this.Host = XMLHandler.getTagValue((Node)stepnode, (String)"host");
            this.userName = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"password")));
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.dnFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"dnFieldName");
            this.failIfNotExist = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"failIfNotExist"));
            this.operationType = LDAPOutputMeta.getOperationTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"operationType"), (String)""));
            this.multiValuedSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"multivaluedseparator");
            this.searchBase = XMLHandler.getTagValue((Node)stepnode, (String)"searchBase");
            this.referralType = LDAPOutputMeta.getReferralTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"referralType"), (String)""));
            this.derefAliasesType = LDAPOutputMeta.getDerefAliasesTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"derefAliasesType"), (String)""));
            this.oldDnFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"oldDnFieldName");
            this.newDnFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"newDnFieldName");
            this.deleteRDN = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"deleteRDN"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                String updateValue;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)fnode, (String)"field");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.update[i] = (updateValue = XMLHandler.getTagValue((Node)fnode, (String)"update")) == null ? Boolean.TRUE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
            this.protocol = XMLHandler.getTagValue((Node)stepnode, (String)"protocol");
            this.trustStorePath = XMLHandler.getTagValue((Node)stepnode, (String)"trustStorePath");
            this.trustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"trustStorePassword"));
            this.trustAllCertificates = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"trustAllCertificates"));
            this.useCertificate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useCertificate"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"LDAPOutputMeta.UnableToLoadFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.useAuthentication = false;
        this.Host = "";
        this.userName = "";
        this.password = "";
        this.port = "389";
        this.dnFieldName = null;
        this.failIfNotExist = true;
        this.multiValuedSeparator = ";";
        this.searchBase = null;
        this.oldDnFieldName = null;
        this.newDnFieldName = null;
        this.deleteRDN = true;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.updateLookup[i] = "name" + (i + 1);
            this.updateStream[i] = "field" + (i + 1);
            this.update[i] = Boolean.TRUE;
        }
        this.operationType = 0;
        this.referralType = 0;
        this.derefAliasesType = 0;
        this.trustStorePath = null;
        this.trustStorePassword = null;
        this.trustAllCertificates = false;
        this.protocol = LdapProtocolFactory.getConnectionTypes(this.log).get(0);
        this.useCertificate = false;
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.useAuthentication = rep.getStepAttributeBoolean(id_step, "useauthentication");
            this.Host = rep.getStepAttributeString(id_step, "host");
            this.userName = rep.getStepAttributeString(id_step, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.port = rep.getStepAttributeString(id_step, "port");
            this.dnFieldName = rep.getStepAttributeString(id_step, "dnFieldName");
            this.failIfNotExist = rep.getStepAttributeBoolean(id_step, "failIfNotExist");
            this.operationType = LDAPOutputMeta.getOperationTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "operationType"), (String)""));
            this.multiValuedSeparator = rep.getStepAttributeString(id_step, "multivaluedseparator");
            this.searchBase = rep.getStepAttributeString(id_step, "searchBase");
            this.referralType = LDAPOutputMeta.getReferralTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "referralType"), (String)""));
            this.derefAliasesType = LDAPOutputMeta.getDerefAliasesTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "referralType"), (String)""));
            this.newDnFieldName = rep.getStepAttributeString(id_step, "newDnFieldName");
            this.oldDnFieldName = rep.getStepAttributeString(id_step, "oldDnFieldName");
            this.deleteRDN = rep.getStepAttributeBoolean(id_step, "deleteRDN");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "field_attribut");
                this.update[i] = rep.getStepAttributeBoolean(id_step, i, "value_update", true);
            }
            this.protocol = rep.getStepAttributeString(id_step, "protocol");
            this.trustStorePath = rep.getStepAttributeString(id_step, "trustStorePath");
            this.trustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "trustStorePassword"));
            this.trustAllCertificates = rep.getStepAttributeBoolean(id_step, "trustAllCertificates");
            this.useCertificate = rep.getStepAttributeBoolean(id_step, "useCertificate");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "useauthentication", this.useAuthentication);
            rep.saveStepAttribute(id_transformation, id_step, "host", this.Host);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.userName);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "dnFieldName", this.dnFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "failIfNotExist", this.failIfNotExist);
            rep.saveStepAttribute(id_transformation, id_step, "operationType", LDAPOutputMeta.getOperationTypeCode(this.operationType));
            rep.saveStepAttribute(id_transformation, id_step, "multivaluedseparator", this.multiValuedSeparator);
            rep.saveStepAttribute(id_transformation, id_step, "searchBase", this.searchBase);
            rep.saveStepAttribute(id_transformation, id_step, "referralType", LDAPOutputMeta.getReferralTypeCode(this.referralType));
            rep.saveStepAttribute(id_transformation, id_step, "derefAliasesType", LDAPOutputMeta.getDerefAliasesCode(this.derefAliasesType));
            rep.saveStepAttribute(id_transformation, id_step, "oldDnFieldName", this.oldDnFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "newDnFieldName", this.newDnFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "deleteRDN", this.deleteRDN);
            for (int i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribut", this.updateStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_update", this.update[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "protocol", this.protocol);
            rep.saveStepAttribute(id_transformation, id_step, "trustStorePath", this.trustStorePath);
            rep.saveStepAttribute(id_transformation, id_step, "trustStorePassword", Encr.encryptPasswordIfNotUsingVariables((String)this.trustStorePassword));
            rep.saveStepAttribute(id_transformation, id_step, "trustAllCertificates", this.trustAllCertificates);
            rep.saveStepAttribute(id_transformation, id_step, "useCertificate", this.useCertificate);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPOutputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPOutputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.Host) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPOutputMeta.CheckResult.HostnameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPOutputMeta.CheckResult.HostnameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.updateLookup.length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPOutputUpdateMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPOutputUpdateMeta.CheckResult.FieldsOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new LDAPOutput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new LDAPOutputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public String toString() {
        return "LDAPConnection " + this.getName();
    }

    @Override
    public String getDerefAliases() {
        return LDAPOutputMeta.getDerefAliasesCode(this.getDerefAliasesType());
    }

    @Override
    public String getReferrals() {
        return LDAPOutputMeta.getReferralTypeCode(this.getReferralType());
    }
}

