/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;

public class KettleDatabaseRepositoryTransAttribute
implements RepositoryAttributeInterface {
    private KettleDatabaseRepositoryConnectionDelegate connectionDelegate;
    private ObjectId transObjectId;

    public KettleDatabaseRepositoryTransAttribute(KettleDatabaseRepositoryConnectionDelegate connectionDelegate, ObjectId transObjectId) {
        this.connectionDelegate = connectionDelegate;
        this.transObjectId = transObjectId;
    }

    public boolean getAttributeBoolean(String code) throws KettleException {
        return this.connectionDelegate.getTransAttributeBoolean(this.transObjectId, 0, code);
    }

    public long getAttributeInteger(String code) throws KettleException {
        return this.connectionDelegate.getTransAttributeInteger(this.transObjectId, 0, code);
    }

    public String getAttributeString(String code) throws KettleException {
        return this.connectionDelegate.getTransAttributeString(this.transObjectId, 0, code);
    }

    public void setAttribute(String code, String value) throws KettleException {
        this.connectionDelegate.insertTransAttribute(this.transObjectId, 0L, code, 0L, value);
    }

    public void setAttribute(String code, boolean value) throws KettleException {
        this.connectionDelegate.insertTransAttribute(this.transObjectId, 0L, code, 0L, value ? "Y" : "N");
    }

    public void setAttribute(String code, long value) throws KettleException {
        this.connectionDelegate.insertTransAttribute(this.transObjectId, 0L, code, value, null);
    }
}

