/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpput;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import java.io.IOException;
import java.text.ParseException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;

public class PDIFTPClient
extends FTPClient {
    private boolean mdtmSupported = true;
    private boolean sizeSupported = true;
    private static Class<?> PKG = PDIFTPClient.class;
    private LogChannelInterface log;

    public PDIFTPClient(LogChannelInterface log) {
        this.log = log;
        log.logBasic(BaseMessages.getString(PKG, (String)"PDIFTPClient.DEBUG.Using.Overridden.FTPClient", (String[])new String[0]));
    }

    public boolean exists(String remoteFile) throws IOException, FTPException {
        char ch;
        this.checkConnection(true);
        if (this.sizeSupported) {
            this.lastReply = this.control.sendCommand("SIZE " + remoteFile);
            ch = this.lastReply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.sizeSupported = false;
            this.log.logDebug("SIZE not supported - trying MDTM");
        }
        if (this.mdtmSupported) {
            this.lastReply = this.control.sendCommand("MDTM " + remoteFile);
            ch = this.lastReply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.mdtmSupported = false;
            this.log.logDebug("MDTM not supported - trying LIST");
        }
        try {
            FTPFile[] files = this.dirDetails(null);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().equals(remoteFile)) continue;
                return files[i].isFile();
            }
            return false;
        }
        catch (ParseException ex) {
            this.log.logBasic(ex.getMessage());
            return false;
        }
    }
}

