/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.TreeMap;

public abstract class SwingUniversalImage {
    private Map<String, BufferedImage> cache = new TreeMap<String, BufferedImage>();

    public abstract boolean isBitmap();

    protected abstract void renderSimple(BufferedImage var1);

    protected abstract void render(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);

    public synchronized BufferedImage getAsBitmapForSize(int width, int height) {
        String key = width + "x" + height;
        BufferedImage result = this.cache.get(key);
        if (result == null) {
            result = SwingUniversalImage.createBitmap(width, height);
            this.renderSimple(result);
            this.cache.put(key, result);
        }
        return result;
    }

    public synchronized BufferedImage getAsBitmapForSize(int width, int height, double angleRadians) {
        int angleDegree;
        for (angleDegree = (int)Math.round(Math.toDegrees(angleRadians)); angleDegree < 0; angleDegree += 360) {
        }
        angleRadians = Math.toRadians(angleDegree %= 360);
        String key = width + "x" + height + "/" + Integer.toString(angleDegree);
        BufferedImage result = this.cache.get(key);
        if (result == null) {
            result = SwingUniversalImage.createDoubleBitmap(width, height);
            Graphics2D gc = SwingUniversalImage.createGraphics(result);
            this.render(gc, result.getWidth() / 2, result.getHeight() / 2, width, height, angleRadians);
            gc.dispose();
            this.cache.put(key, result);
        }
        return result;
    }

    public synchronized void drawToGraphics(Graphics2D gc, int locationX, int locationY, int width, int height) {
        this.render(gc, locationX + width / 2, locationY + height / 2, width, height, 0.0);
    }

    public synchronized void drawToGraphics(Graphics2D gc, int centerX, int centerY, int width, int height, double angleRadians) {
        this.render(gc, centerX, centerY, width, height, angleRadians);
    }

    public static BufferedImage createBitmap(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public static BufferedImage createDoubleBitmap(int width, int height) {
        int sz = Math.max(width, height) * 2;
        return new BufferedImage(sz, sz, 2);
    }

    public static Graphics2D createGraphics(BufferedImage area) {
        Graphics2D gc = (Graphics2D)area.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gc.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        gc.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        return gc;
    }
}

