/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;

public class RowMetaAndData
implements Cloneable {
    private RowMetaInterface rowMeta;
    private Object[] data;

    public RowMetaAndData() {
        this.clear();
    }

    public RowMetaAndData(RowMetaInterface rowMeta, Object ... data) {
        this.rowMeta = rowMeta;
        this.data = data;
    }

    public RowMetaAndData clone() {
        RowMetaAndData c = new RowMetaAndData();
        c.rowMeta = this.rowMeta.clone();
        try {
            c.data = this.rowMeta.cloneRow(this.data);
        }
        catch (KettleValueException e) {
            throw new RuntimeException("Problem with clone row detected in RowMetaAndData", e);
        }
        return c;
    }

    public String toString() {
        try {
            return this.rowMeta.getString(this.data);
        }
        catch (KettleValueException e) {
            return this.rowMeta.toString() + ", error presenting data: " + e.toString();
        }
    }

    public Object[] getData() {
        return this.data;
    }

    public void setData(Object[] data) {
        this.data = data;
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    public int hashCode() {
        try {
            return this.rowMeta.hashCode(this.data);
        }
        catch (KettleValueException e) {
            throw new RuntimeException("Row metadata and data: unable to calculate hashcode because of a data conversion problem", e);
        }
    }

    public boolean equals(Object obj) {
        try {
            return this.rowMeta.compare(this.data, ((RowMetaAndData)obj).getData()) == 0;
        }
        catch (KettleValueException e) {
            throw new RuntimeException("Row metadata and data: unable to compare rows because of a data conversion problem", e);
        }
    }

    public void addValue(ValueMetaInterface valueMeta, Object valueData) {
        if (valueMeta.isInteger() && valueData instanceof ObjectId) {
            valueData = new LongObjectId((ObjectId)valueData).longValue();
        }
        this.data = RowDataUtil.addValueData(this.data, this.rowMeta.size(), valueData);
        this.rowMeta.addValueMeta(valueMeta);
    }

    public void addValue(String valueName, int valueType, Object valueData) {
        this.addValue(new ValueMeta(valueName, valueType), valueData);
    }

    public void clear() {
        this.rowMeta = new RowMeta();
        this.data = new Object[0];
    }

    public long getInteger(String valueName, long def) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.getInteger(idx, def);
    }

    public long getInteger(int index, long def) throws KettleValueException {
        Long number = this.rowMeta.getInteger(this.data, index);
        if (number == null) {
            return def;
        }
        return number;
    }

    public Long getInteger(String valueName) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.rowMeta.getInteger(this.data, idx);
    }

    public Long getInteger(int index) throws KettleValueException {
        return this.rowMeta.getInteger(this.data, index);
    }

    public double getNumber(String valueName, double def) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.getNumber(idx, def);
    }

    public double getNumber(int index, double def) throws KettleValueException {
        Double number = this.rowMeta.getNumber(this.data, index);
        if (number == null) {
            return def;
        }
        return number;
    }

    public Date getDate(String valueName, Date def) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.getDate(idx, def);
    }

    public Date getDate(int index, Date def) throws KettleValueException {
        Date date = this.rowMeta.getDate(this.data, index);
        if (date == null) {
            return def;
        }
        return date;
    }

    public BigDecimal getBigNumber(String valueName, BigDecimal def) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.getBigNumber(idx, def);
    }

    public BigDecimal getBigNumber(int index, BigDecimal def) throws KettleValueException {
        BigDecimal number = this.rowMeta.getBigNumber(this.data, index);
        if (number == null) {
            return def;
        }
        return number;
    }

    public boolean getBoolean(String valueName, boolean def) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.getBoolean(idx, def);
    }

    public boolean getBoolean(int index, boolean def) throws KettleValueException {
        Boolean b = this.rowMeta.getBoolean(this.data, index);
        if (b == null) {
            return def;
        }
        return b;
    }

    public String getString(String valueName, String def) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.getString(idx, def);
    }

    public String getString(int index, String def) throws KettleValueException {
        String string = this.rowMeta.getString(this.data, index);
        if (string == null) {
            return def;
        }
        return string;
    }

    public byte[] getBinary(String valueName, byte[] def) throws KettleValueException {
        int idx = this.rowMeta.indexOfValue(valueName);
        if (idx < 0) {
            throw new KettleValueException("Unknown column '" + valueName + "'");
        }
        return this.getBinary(idx, def);
    }

    public byte[] getBinary(int index, byte[] def) throws KettleValueException {
        byte[] bin = this.rowMeta.getBinary(this.data, index);
        if (bin == null) {
            return def;
        }
        return bin;
    }

    public int compare(RowMetaAndData compare, int[] is, boolean[] bs) throws KettleValueException {
        return this.rowMeta.compare(this.data, compare.getData(), is);
    }

    public boolean isNumeric(int index) {
        return this.rowMeta.getValueMeta(index).isNumeric();
    }

    public int size() {
        return this.rowMeta.size();
    }

    public ValueMetaInterface getValueMeta(int index) {
        return this.rowMeta.getValueMeta(index);
    }

    public void removeValue(String valueName) throws KettleValueException {
        int index = this.rowMeta.indexOfValue(valueName);
        if (index < 0) {
            throw new KettleValueException("Unable to find '" + valueName + "' in the row");
        }
        this.removeValue(index);
    }

    public synchronized void removeValue(int index) {
        this.rowMeta.removeValueMeta(index);
        this.data = RowDataUtil.removeItem(this.data, index);
    }
}

