/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

public enum ObjectLocationSpecificationMethod {
    FILENAME("filename", "Filename"),
    REPOSITORY_BY_NAME("rep_name", "Specify by name in repository"),
    REPOSITORY_BY_REFERENCE("rep_ref", "Specify by reference in repository");

    private String code;
    private String description;

    private ObjectLocationSpecificationMethod(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDescriptions() {
        String[] desc = new String[ObjectLocationSpecificationMethod.values().length];
        for (int i = 0; i < ObjectLocationSpecificationMethod.values().length; ++i) {
            desc[i] = ObjectLocationSpecificationMethod.values()[i].getDescription();
        }
        return desc;
    }

    public static ObjectLocationSpecificationMethod getSpecificationMethodByCode(String code) {
        for (ObjectLocationSpecificationMethod method : ObjectLocationSpecificationMethod.values()) {
            if (!method.getCode().equals(code)) continue;
            return method;
        }
        return null;
    }

    public static ObjectLocationSpecificationMethod getSpecificationMethodByDescription(String description) {
        for (ObjectLocationSpecificationMethod method : ObjectLocationSpecificationMethod.values()) {
            if (!method.getDescription().equals(description)) continue;
            return method;
        }
        return null;
    }
}

