/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.jfor.jfor.main.JForVersionInfo;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfFile;
import org.jfor.jfor.rtflib.rtfdoc.RtfStringConverter;

public abstract class RtfElement {
    protected final Writer m_writer;
    protected final RtfContainer m_parent;
    protected final RtfAttributes m_attrib;
    private boolean m_written;
    private boolean m_closed;
    private final int m_id = m_idCounter++;
    private static int m_idCounter;

    RtfElement(RtfContainer rtfContainer, Writer writer) throws IOException {
        this(rtfContainer, writer, null);
    }

    RtfElement(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        this.m_parent = rtfContainer;
        RtfAttributes rtfAttributes2 = this.m_attrib = rtfAttributes != null ? rtfAttributes : new RtfAttributes();
        if (this.m_parent != null) {
            this.m_parent.addChild(this);
        }
        this.m_writer = writer;
        this.m_written = false;
    }

    public final void close() throws IOException {
        this.m_closed = true;
    }

    public final void writeRtf() throws IOException {
        if (!this.m_written) {
            this.m_written = true;
            if (this.okToWriteRtf()) {
                this.writeRtfPrefix();
                this.writeRtfContent();
                this.writeRtfSuffix();
            }
        }
    }

    protected final void writeControlWord(String string) throws IOException {
        this.m_writer.write(92);
        this.m_writer.write(string);
        this.m_writer.write(32);
    }

    protected final void writeStarControlWord(String string) throws IOException {
        this.m_writer.write("\\*\\");
        this.m_writer.write(string);
        this.m_writer.write(32);
    }

    protected final void writeStarControlWordNS(String string) throws IOException {
        this.m_writer.write("\\*\\");
        this.m_writer.write(string);
    }

    protected final void writeControlWordNS(String string) throws IOException {
        this.m_writer.write(92);
        this.m_writer.write(string);
    }

    protected void writeRtfPrefix() throws IOException {
    }

    protected abstract void writeRtfContent() throws IOException;

    protected void writeRtfSuffix() throws IOException {
    }

    protected final void writeGroupMark(boolean bl) throws IOException {
        this.m_writer.write(bl ? "{" : "}");
    }

    protected void writeAttributes(RtfAttributes rtfAttributes, String[] stringArray) throws IOException {
        if (rtfAttributes == null) {
            return;
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (rtfAttributes.isSet(string)) {
                    this.writeOneAttribute(string, rtfAttributes.getValue(string));
                }
                ++n;
            }
        } else {
            Iterator iterator = rtfAttributes.nameIterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!rtfAttributes.isSet(string)) continue;
                this.writeOneAttribute(string, rtfAttributes.getValue(string));
            }
        }
    }

    protected void writeOneAttribute(String string, Object object) throws IOException {
        String string2 = string;
        if (object instanceof Integer) {
            string2 = string2 + object;
        } else if (object instanceof String) {
            string2 = string2 + object;
        }
        this.writeControlWord(string2);
    }

    protected void writeOneAttributeNS(String string, Object object) throws IOException {
        String string2 = string;
        if (object instanceof Integer) {
            string2 = string2 + object;
        } else if (object instanceof String) {
            string2 = string2 + object;
        }
        this.writeControlWordNS(string2);
    }

    protected boolean okToWriteRtf() {
        return true;
    }

    void dump(Writer writer, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            writer.write(32);
            ++n2;
        }
        writer.write(this.toString());
        writer.write(10);
        writer.flush();
    }

    public String toString() {
        return this == null ? "null" : this.getClass().getName() + " #" + this.m_id;
    }

    boolean isClosed() {
        return this.m_closed;
    }

    RtfFile getRtfFile() {
        RtfElement rtfElement = this;
        while (rtfElement.m_parent != null) {
            rtfElement = rtfElement.m_parent;
        }
        return (RtfFile)rtfElement;
    }

    RtfElement getParentOfClass(Class clazz) {
        RtfElement rtfElement = null;
        RtfElement rtfElement2 = this;
        while (rtfElement2.m_parent != null) {
            rtfElement2 = rtfElement2.m_parent;
            if (!clazz.isAssignableFrom(rtfElement2.getClass())) continue;
            rtfElement = rtfElement2;
            break;
        }
        return rtfElement;
    }

    public abstract boolean isEmpty();

    protected void writeExceptionInRtf(Exception exception) throws IOException {
        this.writeGroupMark(true);
        this.writeControlWord("par");
        this.writeControlWord("fs48");
        RtfStringConverter.getInstance().writeRtfString(this.m_writer, JForVersionInfo.getShortVersionInfo() + ": ");
        RtfStringConverter.getInstance().writeRtfString(this.m_writer, exception.getClass().getName());
        this.writeControlWord("fs20");
        RtfStringConverter.getInstance().writeRtfString(this.m_writer, " " + exception.toString());
        this.writeControlWord("par");
        this.writeGroupMark(false);
    }

    public RtfAttributes getRtfAttributes() {
        return this.m_attrib;
    }
}

