/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.jfor.jfor.rtflib.rtfdoc.IRtfBookmarkContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfElement;

public class RtfBookmark
extends RtfElement {
    private String bookmark = null;
    public static int maxBookmarkLength = 40;
    public static char replaceCharacter = (char)95;

    RtfBookmark(IRtfBookmarkContainer iRtfBookmarkContainer, Writer writer, String string) throws IOException {
        super((RtfContainer)((Object)iRtfBookmarkContainer), writer);
        int n = string.length();
        this.bookmark = string.substring(0, n < maxBookmarkLength ? n : maxBookmarkLength);
        this.bookmark = this.bookmark.replace('.', replaceCharacter);
        this.bookmark = this.bookmark.replace(' ', replaceCharacter);
    }

    public void writeRtfPrefix() throws IOException {
        this.startBookmark();
    }

    public void writeRtfContent() throws IOException {
        this.getRtfFile().getLog().logInfo("Write bookmark '" + this.bookmark + "'.");
    }

    public void writeRtfSuffix() throws IOException {
        this.endBookmark();
    }

    private void startBookmark() throws IOException {
        this.writeRtfBookmark("bkmkstart");
    }

    private void endBookmark() throws IOException {
        this.writeRtfBookmark("bkmkend");
    }

    private void writeRtfBookmark(String string) throws IOException {
        if (this.bookmark == null) {
            return;
        }
        this.writeGroupMark(true);
        this.writeStarControlWord(string);
        this.m_writer.write(this.bookmark);
        this.writeGroupMark(false);
    }

    public boolean isEmpty() {
        return this.bookmark == null || this.bookmark.trim().length() == 0;
    }
}

