/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.SimpleCompiler;
import org.codehaus.janino.util.enumerator.EnumeratorSet;

public class ClassBodyEvaluator
extends SimpleCompiler {
    public static final String DEFAULT_CLASS_NAME = "SC";
    protected static final Class[] ZERO_CLASSES = new Class[0];
    private String[] optionalDefaultImports = null;
    protected String className = "SC";
    private Class optionalExtendedType = null;
    private Class[] implementedTypes = ZERO_CLASSES;
    private Class result = null;
    static /* synthetic */ Class class$org$codehaus$janino$ClassBodyEvaluator;

    public ClassBodyEvaluator(String classBody) throws CompileException, Parser.ParseException, Scanner.ScanException {
        this.cook(classBody);
    }

    public ClassBodyEvaluator(String optionalFileName, InputStream is) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.cook(optionalFileName, is);
    }

    public ClassBodyEvaluator(String optionalFileName, Reader reader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.cook(optionalFileName, reader);
    }

    public ClassBodyEvaluator(Scanner scanner, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator(Scanner scanner, Class optionalExtendedType, Class[] implementedTypes, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setExtendedType(optionalExtendedType);
        this.setImplementedTypes(implementedTypes);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class[] implementedTypes, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setClassName(className);
        this.setExtendedType(optionalExtendedType);
        this.setImplementedTypes(implementedTypes);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ClassBodyEvaluator() {
    }

    public void setDefaultImports(String[] optionalDefaultImports) {
        this.assertNotCooked();
        this.optionalDefaultImports = optionalDefaultImports;
    }

    public void setClassName(String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        this.assertNotCooked();
        this.className = className;
    }

    public void setExtendedType(Class optionalExtendedType) {
        this.assertNotCooked();
        this.optionalExtendedType = optionalExtendedType;
    }

    public void setImplementedTypes(Class[] implementedTypes) {
        if (implementedTypes == null) {
            throw new NullPointerException("Zero implemented types must be specified as \"new Class[0]\", not \"null\"");
        }
        this.assertNotCooked();
        this.implementedTypes = implementedTypes;
    }

    public void cook(Scanner scanner) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setUpClassLoaders();
        Java.CompilationUnit compilationUnit = this.makeCompilationUnit(scanner);
        Java.PackageMemberClassDeclaration cd = this.addPackageMemberClassDeclaration(scanner.location(), compilationUnit);
        Parser parser = new Parser(scanner);
        while (!scanner.peek().isEOF()) {
            parser.parseClassBodyDeclaration(cd);
        }
        this.result = this.compileToClass(compilationUnit, DebuggingInformation.ALL, this.className);
    }

    protected final Java.CompilationUnit makeCompilationUnit(Scanner optionalScanner) throws Parser.ParseException, Scanner.ScanException, IOException {
        Java.CompilationUnit cu = new Java.CompilationUnit(optionalScanner == null ? null : optionalScanner.getFileName());
        if (this.optionalDefaultImports != null) {
            for (int i = 0; i < this.optionalDefaultImports.length; ++i) {
                Scanner s = new Scanner(null, new StringReader(this.optionalDefaultImports[i]));
                cu.addImportDeclaration(new Parser(s).parseImportDeclarationBody());
                if (s.peek().isEOF()) continue;
                throw new Parser.ParseException("Unexpected token \"" + s.peek() + "\" in default import", s.location());
            }
        }
        if (optionalScanner != null) {
            Parser parser = new Parser(optionalScanner);
            while (optionalScanner.peek().isKeyword("import")) {
                cu.addImportDeclaration(parser.parseImportDeclaration());
            }
        }
        return cu;
    }

    protected Java.PackageMemberClassDeclaration addPackageMemberClassDeclaration(Location location, Java.CompilationUnit compilationUnit) throws Parser.ParseException {
        String cn = this.className;
        int idx = cn.lastIndexOf(46);
        if (idx != -1) {
            compilationUnit.setPackageDeclaration(new Java.PackageDeclaration(location, cn.substring(0, idx)));
            cn = cn.substring(idx + 1);
        }
        Java.PackageMemberClassDeclaration tlcd = new Java.PackageMemberClassDeclaration(location, null, 1, cn, this.classToType(location, this.optionalExtendedType), this.classesToTypes(location, this.implementedTypes));
        compilationUnit.addPackageMemberTypeDeclaration(tlcd);
        return tlcd;
    }

    protected final Class compileToClass(Java.CompilationUnit compilationUnit, EnumeratorSet debuggingInformation, String newClassName) throws CompileException {
        ClassLoader cl = this.compileToClassLoader(compilationUnit, debuggingInformation);
        try {
            return cl.loadClass(newClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("SNO: Generated compilation unit does not declare class \"" + newClassName + "\"");
        }
    }

    public Class getClazz() {
        if (this.getClass() != (class$org$codehaus$janino$ClassBodyEvaluator == null ? (class$org$codehaus$janino$ClassBodyEvaluator = ClassBodyEvaluator.class$("org.codehaus.janino.ClassBodyEvaluator")) : class$org$codehaus$janino$ClassBodyEvaluator)) {
            throw new IllegalStateException("Must not be called on derived instances");
        }
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.result;
    }

    public static Object createFastClassBodyEvaluator(Scanner scanner, Class optionalBaseType, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        Class[] classArray;
        Class clazz = optionalBaseType != null && !optionalBaseType.isInterface() ? optionalBaseType : null;
        if (optionalBaseType != null && optionalBaseType.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = optionalBaseType;
        } else {
            classArray = new Class[]{};
        }
        return ClassBodyEvaluator.createFastClassBodyEvaluator(scanner, DEFAULT_CLASS_NAME, clazz, classArray, optionalParentClassLoader);
    }

    public static Object createFastClassBodyEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class[] implementedTypes, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        Class c = new ClassBodyEvaluator(scanner, className, optionalExtendedType, implementedTypes, optionalParentClassLoader).getClazz();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new CompileException("Cannot instantiate abstract class -- one or more method implementations are missing", null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

