/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import de.his.tools.LoggingStreamReader;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SystemUtil {
    private static Logger logger = Logger.getLogger(SystemUtil.class);

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e, (Throwable)e);
        }
    }

    public static int executeWithOutputLogging(String command) throws IOException, InterruptedException {
        logger.debug((Object)command);
        Process process = Runtime.getRuntime().exec(command);
        SystemUtil.logOutput(process);
        process.waitFor();
        return process.exitValue();
    }

    public static int executeWithOutputLogging(String ... command) throws IOException, InterruptedException {
        logger.debug(Arrays.asList(command));
        Process process = Runtime.getRuntime().exec(command);
        SystemUtil.logOutput(process);
        process.waitFor();
        return process.exitValue();
    }

    public static void logOutput(Process process) throws InterruptedException {
        LoggingStreamReader lsr1 = new LoggingStreamReader(process.getInputStream());
        lsr1.start();
        LoggingStreamReader lsr2 = new LoggingStreamReader(process.getErrorStream(), Level.WARN);
        lsr2.start();
    }
}

