/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import de.his.tools.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ReflectionUtil {
    private static Logger logger = Logger.getLogger(ReflectionUtil.class);

    public static boolean isTypeCompatible(Class<?> classObject, String interfaceName) {
        Class<?> superClass;
        boolean found = false;
        if (classObject.getName().equals(interfaceName)) {
            return true;
        }
        for (Class<?> interf : classObject.getInterfaces()) {
            if (found) break;
            String className = interf.getName();
            found = interfaceName.equals(className);
            if (found) continue;
            found = ReflectionUtil.isTypeCompatible(interf, interfaceName);
        }
        if (!found && (superClass = classObject.getSuperclass()) != null) {
            found = ReflectionUtil.isTypeCompatible(superClass, interfaceName);
        }
        return found;
    }

    public static Class<?> getClassForName(String className, String interfaceName) throws ClassNotFoundException {
        Class<?> moduleClass;
        try {
            moduleClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (className.endsWith(".class")) {
                try {
                    className = className.substring(0, className.length() - 6);
                    moduleClass = Class.forName(className);
                    logger.debug((Object)("Klasse " + className + " wurde ohne Suffix \".class\" gefunden."));
                }
                catch (ClassNotFoundException e2) {
                    throw e;
                }
            }
            throw e;
        }
        if (interfaceName != null && !ReflectionUtil.isTypeCompatible(moduleClass, interfaceName)) {
            throw new IllegalArgumentException(className + " implementiert " + interfaceName + " nicht!");
        }
        return moduleClass;
    }

    public static <T> T createObject(Class<T> cl, String[] argClassNames, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        int nofArgs;
        int nofArgClassNames = argClassNames != null ? argClassNames.length : 0;
        int n = nofArgs = args != null ? args.length : 0;
        if (nofArgClassNames != nofArgs) {
            throw new IllegalArgumentException("Anzahl der Argumente ist ungleich der Anzahl der Argument-Beschreibungen!");
        }
        T clObj = null;
        if (argClassNames != null) {
            Class[] argClasses = new Class[nofArgs];
            for (int i = 0; i < nofArgs; ++i) {
                argClasses[i] = Class.forName(argClassNames[i]);
            }
            Constructor<T> constructor = cl.getConstructor(argClasses);
            clObj = constructor.newInstance(args);
        } else {
            clObj = cl.newInstance();
        }
        return clObj;
    }

    public static Object createObject(String className, String interfaceName) {
        return ReflectionUtil.createObject(className, interfaceName, null, null);
    }

    public static Object createObject(String className, String interfaceName, String[] argClassNames, Object[] args) {
        Object clObj = null;
        try {
            Class<?> cl = ReflectionUtil.getClassForName(className, interfaceName);
            clObj = ReflectionUtil.createObject(cl, argClassNames, args);
        }
        catch (Throwable err) {
            logger.error((Object)("Initialisierung von " + className + ": " + err), err);
        }
        return clObj;
    }

    public static boolean isCalledByJUnit() {
        StringWriter sw = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(sw));
        return StringUtil.containsWord(sw.toString(), "junit") > -1;
    }

    public static void invokeStaticMethod(String className, String methodName, Class<?>[] parameterTypes, Object[] parameterValues) {
        try {
            Class<?> clazz = Class.forName(className);
            Method m = clazz.getMethod(methodName, parameterTypes);
            if (m != null) {
                m.invoke(null, parameterValues);
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)e);
        }
        catch (SecurityException e) {
            logger.debug((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.debug((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.debug((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.debug((Object)e);
        }
    }
}

