/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchResponse;

public class OpenIDAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(OpenIDAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        if (request == null || authProp.getProperty("openid.claimed_id") == null) {
            return userProp;
        }
        Identifier identifier = this.verifyResponse(request);
        if (identifier != null) {
            userProp.put("username", identifier.getIdentifier());
            userProp.put("authenticated", "y");
        }
        return userProp;
    }

    public String authRequest(ConsumerManager manager, String servletURL, String userSuppliedString, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String returnToUrl = servletURL + "?state=user&type=1";
            List discoveries = manager.discover(userSuppliedString);
            DiscoveryInformation discovered = manager.associate(discoveries);
            request.getSession().setAttribute("openid-disc", (Object)discovered);
            AuthRequest authReq = manager.authenticate(discovered, returnToUrl);
            String target = authReq.getDestinationUrl(true);
            logger.debug((Object)("target: " + target));
            response.sendRedirect(target);
            return null;
        }
        catch (OpenIDException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public Identifier verifyResponse(HttpServletRequest request) {
        ConsumerManager manager = (ConsumerManager)request.getSession().getAttribute("session_openIDConsumerManager");
        request.getSession().removeAttribute("session_openIDConsumerManager");
        if (manager == null) {
            logger.debug((Object)("no openIDConsumerManager in session " + request.getSession().getId()));
            return null;
        }
        try {
            VerificationResult verification;
            Identifier verified;
            ParameterList response = new ParameterList(request.getParameterMap());
            DiscoveryInformation discovered = (DiscoveryInformation)request.getSession().getAttribute("openid-disc");
            StringBuffer receivingURL = request.getRequestURL();
            String queryString = request.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(request.getQueryString());
            }
            if ((verified = (verification = manager.verify(receivingURL.toString(), response, discovered)).getVerifiedId()) != null) {
                FetchResponse fetchResponse;
                List emails;
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0") && (emails = (fetchResponse = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0")).getAttributeValues("email")) != null && !emails.isEmpty()) {
                    Object email = emails.get(0);
                    logger.trace((Object)("emails: " + email));
                }
                return verified;
            }
        }
        catch (OpenIDException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }
}

