/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.security.auth.plugin.PasswordChanger;
import de.his.tools.PropUtil;
import de.his.tools.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ExecuteAuth
implements AuthenticationPlugin,
PasswordChanger {
    private static Logger logger = Logger.getLogger(ExecuteAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        int exitValue = -1;
        String cmd = confElement.getChildText("command");
        Properties temp = (Properties)authProp.clone();
        temp.putAll((Map<?, ?>)userProp);
        exitValue = this.execute(cmd, temp);
        if (exitValue == 0) {
            userProp.putAll((Map<?, ?>)PropUtil.xmlToProperties(confElement.getChild("user-prop")));
            userProp.put("authenticated", "y");
        }
        return userProp;
    }

    private int execute(String cmd, Properties authProp) {
        if (cmd != null && !cmd.trim().equals("")) {
            Properties temp = PropUtil.encodeURL(authProp);
            try {
                Process process = Runtime.getRuntime().exec(StringUtil.argsubst(cmd, temp));
                process.waitFor();
                int exitValue = process.exitValue();
                logger.debug((Object)(cmd + ": " + exitValue));
                return exitValue;
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public ArrayList<String> changePasswort(Element confElement, Properties authProps) {
        ArrayList<String> res = new ArrayList<String>();
        String cmd = confElement.getChild("change-password").getChildText("command");
        int exitValue = this.execute(cmd, authProps);
        if (exitValue != 0) {
            res.add("password_fatal");
        }
        return res;
    }

    @Override
    public boolean isPasswortChangeable(Element confElement) {
        return confElement.getChild("change-password") != null;
    }
}

