/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.XMLUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class CopyPropertyAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(CopyPropertyAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        Properties temp = (Properties)authProp.clone();
        temp.putAll((Map<?, ?>)userProp);
        for (Element element : XMLUtil.getChildren(confElement.getChild("rules"))) {
            this.copy(element, temp, userProp);
        }
        return userProp;
    }

    void copy(Element element, Properties source, Properties target) {
        String srcName = element.getAttributeValue("source-property");
        String targetName = element.getAttributeValue("target-property");
        String regex = element.getAttributeValue("regex");
        String replacement = element.getAttributeValue("replacement");
        if (srcName == null || targetName == null) {
            logger.warn((Object)"source-property or target-property is null");
            return;
        }
        String value = source.getProperty(srcName);
        if (value == null) {
            logger.debug((Object)("source-property " + srcName + " is null, removing target-property " + targetName));
            target.remove(targetName);
            return;
        }
        if (regex != null) {
            if (!value.matches(regex)) {
                logger.debug((Object)("source-property " + srcName + " with value \"" + value + "\" does not match regex \"" + regex + "\", removing target-property " + targetName));
                target.remove(targetName);
                return;
            }
            if (replacement != null) {
                value = value.replaceAll(regex, replacement);
            }
        }
        target.put(targetName, value);
    }
}

