/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.dbforms.util.MessageResource;
import org.dbforms.util.Util;

public class MessageResources {
    public static String LOCALE_KEY = "org_dbforms_LOCALE";
    private static MessageResource msgRes = null;

    public static void setLocale(HttpServletRequest request, Locale locale) {
        HttpSession session = request.getSession();
        session.setAttribute(LOCALE_KEY, (Object)locale);
    }

    public static Locale getLocale(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        HttpSession session = request.getSession();
        if (session.getAttribute(LOCALE_KEY) == null) {
            session.setAttribute(LOCALE_KEY, (Object)request.getLocale());
        }
        return (Locale)session.getAttribute(LOCALE_KEY);
    }

    public static String getMessage(HttpServletRequest request, String msg) {
        return MessageResources.getMessage(msg, MessageResources.getLocale(request), msg);
    }

    public static String getMessage(String msg, Locale locale, String defaultMsg) {
        String s = MessageResources.getMessage(msg, locale);
        if (Util.isNull(s)) {
            s = defaultMsg;
        }
        return s;
    }

    public static String getMessage(String msg, Locale loc) {
        return msgRes == null ? null : msgRes.getMessage(msg, loc);
    }

    public static String getMessage(String msg, Locale loc, String[] parms) {
        return msgRes == null ? null : msgRes.getMessage(msg, loc, parms);
    }

    public static void setSubClass(String subClass) {
        msgRes = new MessageResource(subClass);
    }
}

