/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.fileupload.FileItem;

public class FileHolder
implements Serializable {
    private FileItem fileItem;
    private String fileName;

    public FileHolder(String fileName, FileItem fileItem) throws IOException, IllegalArgumentException {
        this.fileName = fileName;
        this.fileItem = fileItem;
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public int getFileLength() {
        return (int)this.fileItem.getSize();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStreamFromBuffer() throws IOException {
        return this.fileItem.getInputStream();
    }

    public void writeBufferToFile(File fileOrDirectory) throws IOException {
        if (this.fileName != null) {
            File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
            try {
                this.fileItem.write(file);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

