/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.DataContainer;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.taglib.StaticDataAddInterface;
import org.dbforms.util.IEscaper;
import org.dbforms.util.IFormatEmbeddedData;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.MessageResources;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.SqlUtil;
import org.dbforms.util.Util;

public abstract class EmbeddedData
extends DbBaseHandlerTag
implements TryCatchFinally,
StaticDataAddInterface {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$taglib$EmbeddedData == null ? (class$org$dbforms$taglib$EmbeddedData = EmbeddedData.class$("org.dbforms.taglib.EmbeddedData")) : class$org$dbforms$taglib$EmbeddedData).getName());
    private IFormatEmbeddedData printfFormat;
    private List data;
    private String dbConnectionName;
    private String disableCache = "false";
    private String format;
    private String formatClass;
    private String name;
    static /* synthetic */ Class class$org$dbforms$taglib$EmbeddedData;

    public void setDbConnectionName(String name) {
        this.dbConnectionName = name;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    public void setDisableCache(String newDisableCache) {
        this.disableCache = newDisableCache;
    }

    public String getDisableCache() {
        return this.disableCache;
    }

    public IEscaper getEscaper() {
        DataContainer parent = (DataContainer)this.getParent();
        IEscaper res = parent.getEscaper();
        return res;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFormatClass(String formatClass) {
        this.formatClass = formatClass;
    }

    public String getFormatClass() {
        return this.formatClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addElement(KeyValuePair pair) {
        this.data.add(pair);
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        this.name = null;
        this.dbConnectionName = null;
        this.format = null;
        this.printfFormat = null;
        this.formatClass = null;
        this.disableCache = "false";
    }

    public int doStartTag() throws JspException {
        this.printfFormat = null;
        if (!Util.isNull(this.format) || !Util.isNull(this.getFormatClass())) {
            if (Util.isNull(this.getFormatClass())) {
                this.setFormatClass(this.getConfig().getDefaultFormatterClass());
            }
            if (Util.isNull(this.format)) {
                this.setFormat("%s");
            }
            if (this.format.indexOf(37) < 0) {
                StringBuffer newFormat = new StringBuffer();
                for (int j = 0; j < this.format.length(); ++j) {
                    if (this.format.charAt(j) == 's') {
                        newFormat.append("%s");
                        continue;
                    }
                    newFormat.append(this.format.charAt(j));
                }
                this.format = newFormat.toString();
            }
            try {
                this.printfFormat = (IFormatEmbeddedData)ReflectionUtil.newInstance(this.getFormatClass());
                this.printfFormat.setLocale(MessageResources.getLocale((HttpServletRequest)this.pageContext.getRequest()));
                this.printfFormat.setFormat(this.format);
            }
            catch (Exception e) {
                logCat.error((Object)("cannot create the new printfFormat [" + this.getFormatClass() + "]"), (Throwable)e);
            }
        }
        int result = 0;
        this.data = null;
        if (this.useCache()) {
            this.data = (List)this.pageContext.getAttribute(this.name, 1);
        }
        if (this.data == null) {
            result = 2;
            logCat.info((Object)("generating Embeddeddata " + this.name));
            DbFormsConfig config = null;
            try {
                config = DbFormsConfigRegistry.instance().lookup();
            }
            catch (Exception e) {
                logCat.error((Object)e);
                throw new JspException((Throwable)e);
            }
            Connection con = null;
            try {
                con = config.getConnection(this.dbConnectionName);
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
            try {
                this.data = this.fetchData(con);
                this.pageContext.setAttribute(this.name, (Object)this.data, 1);
            }
            catch (SQLException sqle) {
                throw new JspException("Database error in EmbeddedData.fetchData " + sqle.toString());
            }
            finally {
                SqlUtil.closeConnection(con);
            }
        }
        logCat.info((Object)(" Embeddeddata " + this.name + " already generated"));
        ((DataContainer)this.getParent()).setEmbeddedData(this.data);
        return result;
    }

    protected abstract List fetchData(Connection var1) throws SQLException;

    protected List formatEmbeddedResultRows(ResultSetVector rsv) {
        String htKey;
        String[] currentRow;
        int i;
        Vector<KeyValuePair> result = new Vector<KeyValuePair>();
        boolean resultSuccessFullyFormated = false;
        if (this.printfFormat != null) {
            try {
                rsv.moveFirst();
                for (i = 0; i < rsv.size(); ++i) {
                    currentRow = rsv.getCurrentRow();
                    htKey = currentRow[0];
                    Object[] objs = rsv.getCurrentRowAsObjects();
                    Object[] objs2 = new Object[objs.length - 1];
                    for (int j = 0; j < objs2.length; ++j) {
                        objs2[j] = objs[j] instanceof String || objs[j] instanceof Byte || objs[j] instanceof Integer || objs[j] instanceof Short || objs[j] instanceof Float || objs[j] instanceof Long || objs[j] instanceof Double ? objs[j + 1] : currentRow[j + 1];
                    }
                    String htValue = this.printfFormat.sprintf(objs2);
                    result.add(new KeyValuePair(htKey, htValue));
                    rsv.moveNext();
                }
                resultSuccessFullyFormated = true;
            }
            catch (IllegalArgumentException ex) {
                logCat.error((Object)("Could not format result using format '" + this.format + "', error message is " + ex.getMessage()));
                logCat.error((Object)"Using fallback method of comma separated list instead");
                result = new Vector();
            }
            catch (NullPointerException npe) {
                logCat.error((Object)("Could not format result using format '" + this.format + "', error message is " + npe.getMessage()));
                logCat.error((Object)"Using fallback method of comma separated list instead");
                result = new Vector();
            }
        }
        if (!resultSuccessFullyFormated) {
            rsv.moveFirst();
            for (i = 0; i < rsv.size(); ++i) {
                currentRow = rsv.getCurrentRow();
                htKey = currentRow[0];
                StringBuffer htValueBuf = new StringBuffer();
                for (int j = 1; j < currentRow.length; ++j) {
                    htValueBuf.append(currentRow[j]);
                    if (j >= currentRow.length - 1) continue;
                    htValueBuf.append(", ");
                }
                String htValue = htValueBuf.toString();
                result.add(new KeyValuePair(htKey, htValue));
                rsv.moveNext();
            }
        }
        return result;
    }

    protected boolean useCache() {
        return !Util.getTrue(this.getDisableCache());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

