/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map;

import de.destatis.core.map.Binding;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.MappingProblem;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.MetaMapping;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.sdf.generator.interpreter.SDFFieldDescriptorFactory;
import de.statspez.sdf.generator.meta.MetaCustomSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MetaMappingCheck {
    private Map bindingGroupOffsetCache;

    public MappingCheckResult check(MetaMapping mapping, MetaSDFMetabeschreibung metaBeschreibung) {
        this.bindingGroupOffsetCache = new HashMap();
        MappingCheckResult result = new MappingCheckResult();
        try {
            this.doCheck(mapping, metaBeschreibung, result);
        }
        catch (Throwable e) {
            result.addProblem(new MappingProblem(1, mapping, "Laufzeitfehler: " + e.toString(), e));
        }
        this.bindingGroupOffsetCache.clear();
        this.bindingGroupOffsetCache = null;
        return result;
    }

    private MappingCheckResult doCheck(MetaMapping mapping, MetaSDFMetabeschreibung metaBeschreibung, MappingCheckResult result) {
        FieldSetBinding messageBinding;
        FieldSetBinding documentBinding;
        if (metaBeschreibung == null) {
            result.addProblem(new MappingProblem(2, mapping, "Es wurde keine Metadatenbeschreibung zugeordnet."));
        } else {
            String metaBeschreibungResourceId;
            String mappingResourceId = mapping.getId();
            if (!mappingResourceId.equals(metaBeschreibungResourceId = metaBeschreibung.getProzedurCode())) {
                result.addProblem(new MappingProblem(2, mapping, "Das Metadaten-Mapping passt nicht zur zugeodneten Metadatenbeschreibung."));
            }
        }
        InterpreterContext context = metaBeschreibung != null ? new InterpreterContext() : null;
        if (metaBeschreibung != null) {
            this.checkSDFMetaBeschreibung(result, metaBeschreibung, mapping);
        }
        if ((documentBinding = mapping.getDocumentBinding()) != null) {
            MetaSDFMetaAusgabegruppe fieldSet = null;
            if (metaBeschreibung != null) {
                fieldSet = metaBeschreibung.getDokumentAusgabegruppe();
            }
            this.checkFieldSetBinding(result, documentBinding, fieldSet, context);
        }
        if ((messageBinding = mapping.getMessageBinding()) != null) {
            MetaSDFMetaAusgabegruppe fieldSet = null;
            if (metaBeschreibung != null) {
                fieldSet = metaBeschreibung.getNachrichtAusgabegruppe();
            }
            this.checkFieldSetBinding(result, messageBinding, fieldSet, context);
        }
        return result;
    }

    private void checkFieldGroupBinding(MappingCheckResult result, FieldGroupBinding fieldGroupBinding, MetaSDFMetaFeldReferenz fieldGroupReference, Map positions, int offset, InterpreterContext context) {
        int len;
        Integer bindingGroupOffset;
        Integer size = fieldGroupBinding.getSize();
        if (offset == 0) {
            if (positions != null && fieldGroupReference != null && fieldGroupReference.getAttributRequired() == 2 && (size == null || size == 0)) {
                result.addProblem(new MappingProblem(3, fieldGroupBinding, "Die Merkmalsgruppe muss vorhanden sein."));
            }
            if (size != null && (size < 0 || size > 1)) {
                result.addProblem(new MappingProblem(3, fieldGroupBinding, "Die Anzahl der Merkmalsgruppe ist ung\u00fcltig. Die Anzahl muss 0, 1 oder leer sein."));
            }
        }
        if ((bindingGroupOffset = (Integer)this.bindingGroupOffsetCache.get(fieldGroupBinding)) == null) {
            bindingGroupOffset = BindingHelper.getOffset(fieldGroupBinding);
            this.bindingGroupOffsetCache.put(fieldGroupBinding, bindingGroupOffset);
        }
        if (bindingGroupOffset == 0) {
            positions = null;
            len = 1;
        } else {
            len = size;
        }
        for (int i = 0; i < len; ++i) {
            Iterator iter = fieldGroupBinding.getBindings();
            while (iter.hasNext()) {
                Iterator references;
                MetaSDFMetaMerkmalsgruppe fieldGroup;
                MetaSDFMetaFeldReferenz reference;
                Binding binding = (Binding)iter.next();
                if (binding instanceof FieldBinding) {
                    reference = null;
                    if (offset == 0 && fieldGroupReference != null) {
                        fieldGroup = (MetaSDFMetaMerkmalsgruppe)fieldGroupReference.getKlasse();
                        references = fieldGroup.getSDFMetaFeldReferenzen();
                        while (references.hasNext()) {
                            MetaSDFMetaFeldReferenz tmpReference = (MetaSDFMetaFeldReferenz)references.next();
                            if (tmpReference.getArt() != 1 || !((MetaSDFMetaMerkmal)tmpReference.getKlasse()).getName().equals(binding.getId())) continue;
                            reference = tmpReference;
                            break;
                        }
                        if (reference == null) {
                            result.addProblem(new MappingProblem(3, binding, "Es existiert kein entsprechendes Merkmal in der Metadatenbeschreibung."));
                        }
                    }
                    this.checkFieldBinding(result, (FieldBinding)binding, reference, positions, offset, context);
                    continue;
                }
                if (binding instanceof FieldGroupBinding) {
                    reference = null;
                    if (offset == 0 && fieldGroupReference != null) {
                        fieldGroup = (MetaSDFMetaMerkmalsgruppe)fieldGroupReference.getKlasse();
                        references = fieldGroup.getSDFMetaFeldReferenzen();
                        while (references.hasNext()) {
                            MetaSDFMetaFeldReferenz check = (MetaSDFMetaFeldReferenz)references.next();
                            if (check.getArt() != 2 || !((MetaSDFMetaMerkmalsgruppe)check.getKlasse()).getName().equals(binding.getId())) continue;
                            reference = check;
                            break;
                        }
                        if (reference == null) {
                            result.addProblem(new MappingProblem(3, binding, "Es existiert keine entsprechende Merkmalsgruppe in der Metadatenbeschreibung."));
                        }
                    }
                    this.checkFieldGroupBinding(result, (FieldGroupBinding)binding, reference, positions, offset, context);
                    continue;
                }
                if (offset != 0) continue;
                result.addProblem(new MappingProblem(1, fieldGroupBinding, "Ung\u00fcltiges Binding: '" + (binding == null ? "null" : binding.getClass().getName()) + "'."));
            }
            offset += bindingGroupOffset.intValue();
        }
    }

    private void checkFieldSetBinding(MappingCheckResult result, FieldSetBinding fieldSetBinding, MetaSDFMetaAusgabegruppe fieldSet, InterpreterContext context) {
        HashMap positions = new HashMap();
        Iterator iter = fieldSetBinding.getBindings();
        while (iter.hasNext()) {
            MetaSDFMetaFeldReferenz check;
            Iterator references;
            MetaSDFMetaFeldReferenz reference;
            Binding binding = (Binding)iter.next();
            if (binding instanceof FieldBinding) {
                reference = null;
                if (fieldSet != null) {
                    references = fieldSet.getSDFMetaFeldReferenzen();
                    while (references.hasNext()) {
                        check = (MetaSDFMetaFeldReferenz)references.next();
                        if (check.getArt() != 1 || !((MetaSDFMetaMerkmal)check.getKlasse()).getName().equals(binding.getId())) continue;
                        reference = check;
                        break;
                    }
                    if (reference == null) {
                        result.addProblem(new MappingProblem(3, binding, "Es existiert kein entsprechendes Merkmal in der Metadatenbeschreibung."));
                    }
                }
                this.checkFieldBinding(result, (FieldBinding)binding, reference, positions, 0, context);
                continue;
            }
            if (binding instanceof FieldGroupBinding) {
                reference = null;
                if (fieldSet != null) {
                    references = fieldSet.getSDFMetaFeldReferenzen();
                    while (references.hasNext()) {
                        check = (MetaSDFMetaFeldReferenz)references.next();
                        if (check.getArt() != 2 || !((MetaSDFMetaMerkmalsgruppe)check.getKlasse()).getName().equals(binding.getId())) continue;
                        reference = check;
                        break;
                    }
                    if (reference == null) {
                        result.addProblem(new MappingProblem(3, binding, "Es existiert keine entsprechende Merkmalsgruppe in der Metadatenbeschreibung."));
                    }
                }
                this.checkFieldGroupBinding(result, (FieldGroupBinding)binding, reference, positions, 0, context);
                continue;
            }
            result.addProblem(new MappingProblem(1, binding, "Ung\u00fcltiges Binding: '" + (binding == null ? "null" : binding.getClass().getName()) + "'."));
        }
    }

    private void checkFieldBinding(MappingCheckResult result, FieldBinding fieldBinding, MetaSDFMetaFeldReferenz fieldReference, Map positions, int offset, InterpreterContext context) {
        Integer position = fieldBinding.getPosition();
        if (position != null) {
            if (offset == 0 && position < 1) {
                result.addProblem(new MappingProblem(2, fieldBinding, "Die Position des Merkmals ist ung\u00fcltig. Die Position muss > 0 oder leer sein."));
            }
            if (positions != null) {
                if (offset != 0) {
                    position = new Integer(position + offset);
                }
                if (positions.containsKey(position)) {
                    result.addProblem(new MappingProblem(3, fieldBinding, "Die Positionsnummer wird mehrfach verwendet."));
                } else {
                    positions.put(position, fieldBinding);
                }
            }
        } else if (offset == 0 && positions != null && fieldReference != null && fieldReference.getAttributRequired() == 2 && fieldBinding.getDefaultValue() == null) {
            result.addProblem(new MappingProblem(3, fieldBinding, "Das Merkmal muss vorhanden sein."));
        }
        if (offset == 0) {
            this.checkDefaultValue(result, fieldBinding, fieldReference, context);
        }
    }

    private void checkDefaultValue(MappingCheckResult result, FieldBinding fieldBinding, MetaSDFMetaFeldReferenz fieldReference, InterpreterContext context) {
        MetaCustomSDFMetaMerkmal merkmal;
        if (fieldReference != null && context != null && fieldBinding.getDefaultValue() != null && (merkmal = (MetaCustomSDFMetaMerkmal)fieldReference.getKlasse()).getSpecification() != null) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(fieldBinding.getId(), fieldBinding.getDefaultValue());
            SimpleDataset dataset = new SimpleDataset(values);
            context.setSatz((SatzInterface)dataset);
            ProgramInterpreter interpreter = new ProgramInterpreter();
            try {
                context.setCurrentField(SDFFieldDescriptorFactory.createSimpleFieldDescriptor((MetaSDFMerkmal)merkmal));
                if (!interpreter.execute(merkmal.getSpecification(), context).asBoolean()) {
                    result.addProblem(new MappingProblem(3, fieldBinding, "Der Wert des Merkmals liegt nicht im definierten Wertebereich."));
                }
            }
            catch (Exception e) {
                result.addProblem(new MappingProblem(1, fieldBinding, "Die Merkmalspr\u00fcfung konnte nicht ausgef\u00fchrt werden.", e));
            }
        }
    }

    private void checkSDFMetaBeschreibung(MappingCheckResult result, MetaSDFMetabeschreibung metaBeschreibung, MetaMapping mapping) {
        MetaSDFMetaAusgabegruppe documentAusgabegruppe = metaBeschreibung.getDokumentAusgabegruppe();
        if (documentAusgabegruppe == null) {
            result.addProblem(new MappingProblem(2, mapping, "Die Metadatenbeschreibung enth\u00e4lt keine Dokumentausgabebruppe."));
        } else {
            FieldSetBinding documentBinding = mapping.getDocumentBinding();
            if (documentBinding == null) {
                result.addProblem(new MappingProblem(2, mapping, "Das Mapping enth\u00e4lt keine Dokumentebene."));
            } else {
                this.checkSDFMetaAusgabegruppe(result, documentAusgabegruppe, documentBinding);
            }
        }
        MetaSDFMetaAusgabegruppe messageAusgabegruppe = metaBeschreibung.getNachrichtAusgabegruppe();
        if (messageAusgabegruppe == null) {
            result.addProblem(new MappingProblem(2, mapping, "Die Metadatenbeschreibung enth\u00e4lt keine Nachrichtausgabebruppe."));
        } else {
            FieldSetBinding messageBinding = mapping.getMessageBinding();
            if (messageBinding == null) {
                result.addProblem(new MappingProblem(2, mapping, "Das Mapping enth\u00e4lt keine Nachrichtenebene."));
            } else {
                this.checkSDFMetaAusgabegruppe(result, messageAusgabegruppe, messageBinding);
            }
        }
    }

    private void checkSDFMetaAusgabegruppe(MappingCheckResult result, MetaSDFMetaAusgabegruppe ausgabegruppe, FieldSetBinding fieldSetBinding) {
        Iterator it = ausgabegruppe.getSDFMetaFeldReferenzen();
        while (it.hasNext()) {
            Binding binding;
            String name;
            MetaSDFMetaFeldReferenz reference = (MetaSDFMetaFeldReferenz)it.next();
            if (reference.getArt() == 1) {
                MetaSDFMetaMerkmal merkmal = (MetaSDFMetaMerkmal)reference.getKlasse();
                name = merkmal.getName();
                binding = BindingHelper.getBindingById(fieldSetBinding, name);
                if (binding instanceof FieldBinding) continue;
                result.addProblem(new MappingProblem(2, fieldSetBinding, "Nicht gemapptes Feld '" + name + "'."));
                continue;
            }
            MetaSDFMetaMerkmalsgruppe merkmalsGruppe = (MetaSDFMetaMerkmalsgruppe)reference.getKlasse();
            name = merkmalsGruppe.getName();
            binding = BindingHelper.getBindingById(fieldSetBinding, name);
            if (!(binding instanceof FieldGroupBinding)) {
                result.addProblem(new MappingProblem(2, fieldSetBinding, "Nicht gemappte Merkmalsgruppe '" + name + "'."));
                continue;
            }
            this.checkSDFMerkmalsgruppe(result, merkmalsGruppe, (FieldGroupBinding)binding);
        }
    }

    private void checkSDFMerkmalsgruppe(MappingCheckResult result, MetaSDFMetaMerkmalsgruppe merkmalsGruppe, FieldGroupBinding fieldGroupBinding) {
        Iterator it = merkmalsGruppe.getSDFMetaFeldReferenzen();
        while (it.hasNext()) {
            Binding binding;
            String name;
            MetaSDFMetaFeldReferenz reference = (MetaSDFMetaFeldReferenz)it.next();
            if (reference.getArt() == 1) {
                MetaSDFMetaMerkmal merkmal = (MetaSDFMetaMerkmal)reference.getKlasse();
                name = merkmal.getName();
                binding = BindingHelper.getBindingById(fieldGroupBinding, name);
                if (binding instanceof FieldBinding) continue;
                result.addProblem(new MappingProblem(2, fieldGroupBinding, "Nicht gemapptes Feld '" + name + "'."));
                continue;
            }
            MetaSDFMetaMerkmalsgruppe subMerkmalsGruppe = (MetaSDFMetaMerkmalsgruppe)reference.getKlasse();
            name = subMerkmalsGruppe.getName();
            binding = BindingHelper.getBindingById(fieldGroupBinding, name);
            if (!(binding instanceof FieldGroupBinding)) {
                result.addProblem(new MappingProblem(2, fieldGroupBinding, "Nicht gemappte Merkmalsgruppe '" + name + "'."));
                continue;
            }
            this.checkSDFMerkmalsgruppe(result, subMerkmalsGruppe, (FieldGroupBinding)binding);
        }
    }
}

