/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer;

import de.destatis.core.connect.TransferProtocol;
import de.destatis.core.connect.transfer.ProtocolHandlerBase;
import de.destatis.core.connect.transfer.https.HttpsProtocolHandler;
import de.destatis.core.connect.transfer.osci.OsciProtocolHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.Contract;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class ProtocolHandlerFactory {
    private static ProtocolHandlerFactory instance = null;
    private HashMap protocolHandlers = new HashMap();

    public static synchronized ProtocolHandlerFactory getInstance() {
        if (instance == null) {
            instance = new ProtocolHandlerFactory();
        }
        return instance;
    }

    public ProtocolHandlerBase createProtocolHandler(ClientConfig conf) {
        ProtocolHandlerBase result = null;
        Class handlerClass = null;
        TransferProtocol protocol = conf.getProtocol();
        if (protocol != null) {
            handlerClass = (Class)this.protocolHandlers.get(protocol);
        }
        assert (handlerClass != null);
        try {
            Constructor constructor = handlerClass.getConstructor(ClientConfig.class);
            result = (ProtocolHandlerBase)constructor.newInstance(conf);
        }
        catch (SecurityException exc) {
            exc.printStackTrace();
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        catch (IllegalArgumentException exc) {
            exc.printStackTrace();
        }
        catch (InstantiationException exc) {
            exc.printStackTrace();
        }
        catch (IllegalAccessException exc) {
            exc.printStackTrace();
        }
        catch (InvocationTargetException exc) {
            exc.printStackTrace();
        }
        assert (result != null);
        return result;
    }

    protected ProtocolHandlerFactory() {
        this.addProtocolHandler(TransferProtocol.HTTPS, HttpsProtocolHandler.class);
        this.addProtocolHandler(TransferProtocol.OSCI, OsciProtocolHandler.class);
    }

    protected void addProtocolHandler(TransferProtocol protocol, Class protocolHandlerClass) {
        Contract.verify(this.protocolHandlers.get(protocol) == null, "Protokollhandler zu dem Protokoll " + protocol + " existiert bereits");
        Contract.verify(ProtocolHandlerBase.class.isAssignableFrom(protocolHandlerClass), "Protokollhandler-Klasse ist nicht von ProtocolHandler abgeleitet");
        this.protocolHandlers.put(protocol, protocolHandlerClass);
    }
}

