/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.ClientAuthenticator;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.Contract;
import java.util.Properties;

public class UserPasswordAuthenticator
implements ClientAuthenticator {
    private String userName = null;
    private char[] password = null;

    public UserPasswordAuthenticator(String userName, char[] password) {
        Contract.verify(userName != null, "Kein Benutzername angegeben!");
        Contract.verify(password != null, "Kein Kennwort angegeben!");
        this.userName = userName;
        this.password = password;
    }

    public UserPasswordAuthenticator(Properties conf) {
        Contract.verify(conf != null, "Keine Properties angegeben!");
        ClientConfig config = new ClientConfig(conf);
        this.userName = config.getUserName();
        this.password = config.getPassword();
        Contract.verify(this.userName != null, "Kein Benutzername angegeben!");
        Contract.verify(this.password != null, "Kein Kennwort angegeben!");
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }
}

