/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.util.Contract;
import java.util.HashMap;

public class ResponseStatus {
    private static final HashMap values = new HashMap();
    private int code;
    private String description;
    public static final ResponseStatus OK = new ResponseStatus(0, "Es ist kein Fehler aufgetreten.");
    public static final ResponseStatus BAD_REQUEST = new ResponseStatus(10, "Die Art und/oder Anzahl der uebermittelten Parameter waren nicht korrekt.");
    public static final ResponseStatus LOGIN_ERROR = new ResponseStatus(20, "Bei der Authentifizierung am gemeinsamen Dateneingang ist ein Fehler aufgetreten.");
    public static final ResponseStatus BAD_RESPONSE = new ResponseStatus(30, "Die empfangene Antwort ist fehlerhaft und kann nicht weiterverarbeitet werden.");
    public static final ResponseStatus FILE_RECEIVE_ERROR = new ResponseStatus(100, "Die uebermittelten Daten konnten nicht verarbeitet werden.");
    public static final ResponseStatus NO_VALID_XML = new ResponseStatus(110, "Die uebermittelten Daten sind kein gueltiges XML-Dokument.");
    public static final ResponseStatus RES_NOT_AVAILABLE = new ResponseStatus(200, "Fuer die angegebene Datenlieferung ist kein Pruefprotokoll vorhanden.");
    public static final ResponseStatus RES_FORMAT_ERROR = new ResponseStatus(210, "Die angegebene Version des Formats DatML/RES wird nicht (mehr) unterstuetzt.");
    public static final ResponseStatus RES_INVALID_ID = new ResponseStatus(220, "Dem gesendeten Eingangsstempel ist keine Datenlieferung des Absenders zugeordnet.");
    public static final ResponseStatus RESOURCE_NOT_AVAILABLE = new ResponseStatus(300, "Fuer die angegebenen Parameter ist keine entsprechende Ressource vorhanden.");
    public static final ResponseStatus RESOURCE_UPTODATE = new ResponseStatus(320, "Fuer die angegebenen Parameter liegt keine aktuellere als die lokal vorhandene Ressource vor.");
    public static final ResponseStatus NO_RESOURCE_FOR_STAT_ID = new ResponseStatus(330, "Keine Ressource f\u00fcr StatistikId vorhanden.");
    public static final ResponseStatus NO_RESOURCE_FOR_REPORTING_PERIOD_TYPE = new ResponseStatus(340, "Keine Ressource f\u00fcr Berichtszeitraumtyp vorhanden.");
    public static final ResponseStatus NO_RESOURCE_FOR_REPORTING_PERIOD = new ResponseStatus(350, "Keine Ressource f\u00fcr Berichtszeitraum vorhanden.");
    public static final ResponseStatus NO_RESOURCE_FOR_COLLECTOR = new ResponseStatus(360, "Keine Ressource f\u00fcr Berichtsempf\u00e4nger vorhanden.");

    public static final ResponseStatus getInstance(int code) {
        Integer key = new Integer(code);
        Contract.verify(values.containsKey(key), "Ungueltiger Statuscode!");
        return (ResponseStatus)values.get(key);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.description;
    }

    public String toString() {
        return this.getMessage() + " (Fehlercode " + this.getCode() + ")";
    }

    private ResponseStatus(int code, String description) {
        this.code = code;
        this.description = description;
        values.put(new Integer(code), this);
    }
}

