/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.HtmlReporter;
import com.atlassian.clover.spi.reporters.html.source.HtmlRenderingSupport;
import com.atlassian.clover.util.CloverUtils;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;

public class RenderPackageSummaryAction
implements Callable {
    private final VelocityContext context;
    private final File basePath;
    private final FullPackageInfo pkg;
    private final boolean linkToClouds;
    private final List childClasses;
    private final HtmlReporter.TreeInfo tree;
    private final Comparator detailComparator;
    private final boolean siblingPagePresent;
    private final List columns;
    private final CloverReportConfig cfg;
    private final HtmlRenderingSupport helper;

    public RenderPackageSummaryAction(VelocityContext context, File basePath, CloverReportConfig cfg, FullPackageInfo pkg, Comparator detailComparator, HtmlReporter.TreeInfo tree, HtmlRenderingSupport helper, boolean siblingPagePresent, boolean linkToClouds) {
        this.context = context;
        this.basePath = basePath;
        this.pkg = pkg;
        this.linkToClouds = linkToClouds;
        this.childClasses = pkg.getClasses();
        this.detailComparator = detailComparator;
        this.tree = tree;
        this.siblingPagePresent = siblingPagePresent;
        this.columns = cfg.getColumns().getClassColumnsCopy();
        this.cfg = cfg;
        this.helper = helper;
    }

    public Object call() throws Exception {
        File outDir = CloverUtils.createOutDir(this.pkg, this.basePath);
        String summaryFilename = this.tree.getPathPrefix() + "pkg-summary.html";
        File outfile = new File(outDir, summaryFilename);
        this.sortClasses(this.childClasses, this.detailComparator);
        this.context.put("linkToClouds", this.linkToClouds);
        this.context.put("currentPageURL", summaryFilename);
        this.context.put("packageInfo", this.pkg);
        this.context.put("headerMetrics", this.pkg.getMetrics());
        this.context.put("headerMetricsRaw", this.pkg.getRawMetrics());
        this.context.put("classlist", this.childClasses);
        this.context.put("tree", this.tree);
        this.context.put("siblingPresent", this.siblingPagePresent);
        this.context.put("topLevel", Boolean.FALSE);
        this.context.put("title", "Classes");
        HtmlReportUtil.addFilteredPercentageToContext(this.context, this.pkg);
        HtmlReportUtil.addColumnsToContext(this.context, this.columns, this.pkg, this.childClasses);
        HtmlReportUtil.mergeTemplateToFile(outfile, this.context, "html_res/pkg-summary.vm");
        return null;
    }

    private void sortClasses(List classes, Comparator comparator) {
        if (classes != null) {
            Collections.sort(classes, comparator);
        }
    }
}

