/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.metrics;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.metrics.PackageMetrics;

public class ProjectMetrics
extends PackageMetrics {
    private int numPackages;

    public ProjectMetrics(HasMetrics owner) {
        super(owner);
    }

    public String getType() {
        return "project";
    }

    public int getNumPackages() {
        return this.numPackages;
    }

    public void setNumPackages(int numPackages) {
        this.numPackages = numPackages;
    }

    public int getNumChildren() {
        return this.getNumPackages();
    }

    public String getChildType() {
        return super.getType();
    }

    public float getAvgClassesPerPackage() {
        return this.getFraction(this.getNumClasses(), this.getNumPackages());
    }

    public float getAvgFilesPerPackage() {
        return this.getFraction(this.getNumFiles(), this.getNumPackages());
    }

    public ProjectMetrics add(ProjectMetrics metrics) {
        super.add(metrics);
        this.numPackages += metrics.numPackages;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectMetrics that = (ProjectMetrics)o;
        return this.numPackages == that.numPackages;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numPackages;
        return result;
    }

    public String toString() {
        return "ProjectMetrics{numPackages=" + this.numPackages + "} " + super.toString();
    }
}

