/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.metrics;

import com.atlassian.clover.api.registry.HasMetrics;

public class BlockMetrics
implements com.atlassian.clover.api.registry.BlockMetrics {
    public static float VALUE_UNDEFINED = -1.0f;
    private HasMetrics owner;
    private int numStatements;
    private int numCoveredStatements;
    private int numBranches;
    private int numCoveredBranches;
    private int complexity;
    private int numTests;
    private int numTestPasses;
    private int numTestFailures;
    private int numTestErrors;
    private float testExecutionTime;

    public static boolean isUndefined(float value) {
        return value == VALUE_UNDEFINED;
    }

    public BlockMetrics(HasMetrics owner) {
        this.owner = owner;
    }

    public HasMetrics getOwner() {
        return this.owner;
    }

    public void setOwner(HasMetrics owner) {
        this.owner = owner;
    }

    public String getType() {
        return "block";
    }

    public int getNumStatements() {
        return this.numStatements;
    }

    public void addNumStatements(int numStatements) {
        this.numStatements += numStatements;
    }

    public void setNumStatements(int numStatements) {
        this.numStatements = numStatements;
    }

    public int getNumCoveredStatements() {
        return this.numCoveredStatements;
    }

    public void addNumCoveredStatements(int numCoveredStatements) {
        this.numCoveredStatements += numCoveredStatements;
    }

    public void setNumCoveredStatements(int numCoveredStatements) {
        this.numCoveredStatements = numCoveredStatements;
    }

    public int getNumBranches() {
        return this.numBranches;
    }

    public void addNumBranches(int numBranches) {
        this.numBranches += numBranches;
    }

    public void setNumBranches(int numBranches) {
        this.numBranches = numBranches;
    }

    public int getNumCoveredBranches() {
        return this.numCoveredBranches;
    }

    public void addNumCoveredBranches(int numCoveredBranches) {
        this.numCoveredBranches += numCoveredBranches;
    }

    public void setNumCoveredBranches(int numCoveredBranches) {
        this.numCoveredBranches = numCoveredBranches;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void addComplexity(int complexity) {
        this.complexity += complexity;
    }

    public void setComplexity(int complexity) {
        this.complexity = complexity;
    }

    public int getNumTests() {
        return this.numTests;
    }

    public void setNumTests(int numTests) {
        this.numTests = numTests;
    }

    public int getNumTestPasses() {
        return this.numTestPasses;
    }

    public void setNumTestPasses(int numTestPasses) {
        this.numTestPasses = numTestPasses;
    }

    public int getNumTestFailures() {
        return this.numTestFailures;
    }

    public void setNumTestFailures(int numTestFailures) {
        this.numTestFailures = numTestFailures;
    }

    public int getNumTestErrors() {
        return this.numTestErrors;
    }

    public void setNumTestErrors(int numTestErrors) {
        this.numTestErrors = numTestErrors;
    }

    public float getTestExecutionTime() {
        return this.testExecutionTime;
    }

    public void setTestExecutionTime(float testExecutionTime) {
        this.testExecutionTime = testExecutionTime;
    }

    public int getNumElements() {
        return this.numStatements + this.numBranches;
    }

    public int getNumCoveredElements() {
        return this.numCoveredStatements + this.numCoveredBranches;
    }

    public int getNumUncoveredElements() {
        return this.getNumElements() - this.getNumCoveredElements();
    }

    public float getPcCoveredStatements() {
        return this.getFraction(this.numCoveredStatements, this.numStatements);
    }

    public float getPcCoveredBranches() {
        return this.getFraction(this.numCoveredBranches, this.numBranches);
    }

    public float getPcCoveredElements() {
        return this.getFraction(this.getNumCoveredElements(), this.getNumElements());
    }

    public float getPcUncoveredElements() {
        float pcCovered = this.getPcCoveredElements();
        return pcCovered < 0.0f ? VALUE_UNDEFINED : 1.0f - pcCovered;
    }

    public float getAvgTestExecutionTime() {
        return this.getFraction(this.getTestExecutionTime(), this.getNumTestsRun());
    }

    public float getPcTestPasses() {
        return this.getFraction(this.getNumTestPasses(), this.getNumTestsRun());
    }

    public float getPcTestErrors() {
        return this.getFraction(this.getNumTestErrors(), this.getNumTestsRun());
    }

    public float getPcTestFailures() {
        return this.getFraction(this.getNumTestFailures(), this.getNumTestsRun());
    }

    public int getNumTestsRun() {
        return this.getNumTestErrors() + this.getNumTestFailures() + this.getNumTestPasses();
    }

    public float getPcTestPassesFailures() {
        int denom = this.getNumTestPasses() + this.getNumTestFailures();
        return denom > 0 ? this.getFraction(this.getNumTestPasses(), denom) : 0.0f;
    }

    public boolean isEmpty() {
        return this.getNumElements() == 0;
    }

    public float getComplexityDensity() {
        return this.getFraction(this.complexity, this.numStatements);
    }

    public BlockMetrics add(com.atlassian.clover.api.registry.BlockMetrics metrics) {
        this.numStatements += metrics.getNumStatements();
        this.numBranches += metrics.getNumBranches();
        this.numCoveredStatements += metrics.getNumCoveredStatements();
        this.numCoveredBranches += metrics.getNumCoveredBranches();
        this.complexity += metrics.getComplexity();
        this.numTests += metrics.getNumTests();
        this.numTestPasses += metrics.getNumTestPasses();
        this.numTestErrors += metrics.getNumTestErrors();
        this.numTestFailures += metrics.getNumTestFailures();
        this.testExecutionTime += metrics.getTestExecutionTime();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMetrics that = (BlockMetrics)o;
        if (this.complexity != that.complexity) {
            return false;
        }
        if (this.numBranches != that.numBranches) {
            return false;
        }
        if (this.numCoveredBranches != that.numCoveredBranches) {
            return false;
        }
        if (this.numCoveredStatements != that.numCoveredStatements) {
            return false;
        }
        if (this.numStatements != that.numStatements) {
            return false;
        }
        if (this.numTestErrors != that.numTestErrors) {
            return false;
        }
        if (this.numTestFailures != that.numTestFailures) {
            return false;
        }
        if (this.numTestPasses != that.numTestPasses) {
            return false;
        }
        return this.numTests == that.numTests;
    }

    public int hashCode() {
        int result = this.numStatements;
        result = 31 * result + this.numCoveredStatements;
        result = 31 * result + this.numBranches;
        result = 31 * result + this.numCoveredBranches;
        result = 31 * result + this.complexity;
        result = 31 * result + this.numTests;
        result = 31 * result + this.numTestPasses;
        result = 31 * result + this.numTestFailures;
        result = 31 * result + this.numTestErrors;
        return result;
    }

    protected float getFraction(float num, int dem) {
        if (dem != 0) {
            return num / (float)dem;
        }
        return VALUE_UNDEFINED;
    }

    public String toString() {
        return "BlockMetrics{owner=" + this.owner + ", numStatements=" + this.numStatements + ", numCoveredStatements=" + this.numCoveredStatements + ", numBranches=" + this.numBranches + ", numCoveredBranches=" + this.numCoveredBranches + ", complexity=" + this.complexity + ", numTests=" + this.numTests + ", numTestPasses=" + this.numTestPasses + ", numTestFailures=" + this.numTestFailures + ", numTestErrors=" + this.numTestErrors + ", testExecutionTime=" + this.testExecutionTime + '}';
    }
}

