/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.io.tags;

import com.atlassian.clover.Logger;
import com.atlassian.clover.io.tags.TagTypeMismatchException;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedIO;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.io.tags.Tags;
import com.atlassian.clover.io.tags.UnknownTagException;
import com.atlassian.clover.io.tags.WrongTagException;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedInputReader
implements TaggedDataInput {
    private final DataInput in;
    private final Tags tags;

    public TaggedInputReader(DataInput in, Tags tags) {
        this.in = in;
        this.tags = tags;
    }

    private boolean readObjectTagAndCheckNullity(int expectedTag) throws IOException {
        this.readTagOrFail(expectedTag);
        return this.in.readBoolean();
    }

    private void readTagOrFail(int expectedTag) throws IOException {
        byte actualTag = this.in.readByte();
        if (TaggedIO.isDebug()) {
            Logger.getInstance().debug("Tag: " + actualTag);
        }
        if (expectedTag != actualTag) {
            throw new WrongTagException(expectedTag, actualTag);
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.readTagOrFail(0);
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.readTagOrFail(1);
        return this.in.readByte();
    }

    @Override
    public short readShort() throws IOException {
        this.readTagOrFail(2);
        return this.in.readShort();
    }

    @Override
    public char readChar() throws IOException {
        this.readTagOrFail(3);
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.readTagOrFail(4);
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.readTagOrFail(5);
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.readTagOrFail(6);
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.readTagOrFail(7);
        return this.in.readDouble();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readObjectTagAndCheckNullity(8) ? null : this.in.readUTF();
    }

    @Override
    public <T extends TaggedPersistent> T read(Class<T> superType) throws IOException {
        Object result;
        if (TaggedIO.isDebug()) {
            Logger.getInstance().debug("Reading " + superType.getName());
        }
        byte tag = this.in.readByte();
        if (TaggedIO.isDebug()) {
            Logger.getInstance().debug("Tag: " + tag);
        }
        if (!this.tags.isDefined(tag)) {
            throw new UnknownTagException(tag);
        }
        boolean isNull = this.in.readBoolean();
        if (!isNull) {
            result = this.tags.invokeObjectReaderFor(tag, this);
            if (!superType.isAssignableFrom(result.getClass())) {
                throw new TagTypeMismatchException(tag, superType.getClass(), result.getClass());
            }
        } else {
            result = null;
        }
        return (T)result;
    }

    @Override
    public <T extends TaggedPersistent> List<T> readList(Class<T> type) throws IOException {
        int count = this.readInt();
        ArrayList<T> entities = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            T entity = this.read(type);
            entities.add(entity);
        }
        return entities;
    }
}

