/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.Logger;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public interface FilesetFileVisitor {
    public void visit(File var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Util {
        static void collectFiles(Project project, List<FileSet> fileSets, FilesetFileVisitor visitor) {
            Util.collectFiles(project, fileSets, false, visitor);
        }

        static void collectFiles(Project project, List<FileSet> fileSets, boolean continueIfMissing, FilesetFileVisitor visitor) {
            for (FileSet fileset : fileSets) {
                String[] includedFiles;
                File baseDir = fileset.getDir(project);
                if (!(!continueIfMissing || baseDir.exists() && baseDir.isDirectory())) {
                    Logger.getInstance().debug("Invalid directory specified: " + baseDir.getAbsolutePath() + ". Ignoring");
                    continue;
                }
                for (String includedFile : includedFiles = fileset.getDirectoryScanner(project).getIncludedFiles()) {
                    visitor.visit(new File(baseDir, includedFile));
                }
            }
        }
    }
}

