/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

public final class ClassInstanceProxy {
    private final String name;
    private final int classHashCode;
    private final int classloaderHashCode;
    private final int hashCode;

    public ClassInstanceProxy(Class classInstance) {
        this.name = classInstance.getName();
        this.classHashCode = classInstance.hashCode();
        this.classloaderHashCode = classInstance.getClassLoader() == null ? 0 : System.identityHashCode(classInstance.getClassLoader());
        this.hashCode = 31 * (31 * this.name.hashCode() + this.classHashCode) + this.classloaderHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassInstanceProxy that = (ClassInstanceProxy)o;
        if (this.classloaderHashCode != that.classloaderHashCode) {
            return false;
        }
        if (this.classHashCode != that.classHashCode) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

