/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.velocity.runtime.parser.node;

import clover.org.apache.velocity.context.InternalContextAdapter;
import clover.org.apache.velocity.exception.MethodInvocationException;
import clover.org.apache.velocity.exception.ParseErrorException;
import clover.org.apache.velocity.exception.ResourceNotFoundException;
import clover.org.apache.velocity.exception.TemplateInitException;
import clover.org.apache.velocity.runtime.parser.ParseException;
import clover.org.apache.velocity.runtime.parser.Parser;
import clover.org.apache.velocity.runtime.parser.ParserVisitor;
import clover.org.apache.velocity.runtime.parser.node.SimpleNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class ASTStringLiteral
extends SimpleNode {
    private boolean interpolate = true;
    private SimpleNode nodeTree = null;
    private String image = "";
    private String interpolateimage = "";
    private boolean containsLineComment;

    public ASTStringLiteral(int id) {
        super(id);
    }

    public ASTStringLiteral(Parser p, int id) {
        super(p, id);
    }

    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        super.init(context, data);
        this.interpolate = this.rsvc.getBoolean("runtime.interpolate.string.literals", true) && this.getFirstToken().image.startsWith("\"") && (this.getFirstToken().image.indexOf(36) != -1 || this.getFirstToken().image.indexOf(35) != -1);
        this.image = this.getFirstToken().image.substring(1, this.getFirstToken().image.length() - 1);
        this.containsLineComment = this.image.indexOf("##") != -1;
        this.interpolateimage = !this.containsLineComment ? this.image + " " : this.image;
        if (this.interpolate) {
            BufferedReader br = new BufferedReader(new StringReader(this.interpolateimage));
            try {
                this.nodeTree = this.rsvc.parse(br, context != null ? context.getCurrentTemplateName() : "StringLiteral", false);
            }
            catch (ParseException e) {
                throw new TemplateInitException("Problem parsing String literal.", e, context != null ? context.getCurrentTemplateName() : "StringLiteral", this.getColumn(), this.getLine());
            }
            this.nodeTree.init(context, this.rsvc);
        }
        return data;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(InternalContextAdapter context) {
        if (this.interpolate) {
            try {
                StringWriter writer = new StringWriter();
                this.nodeTree.render(context, writer);
                String ret = writer.toString();
                if (!this.containsLineComment && ret.length() > 0) {
                    return ret.substring(0, ret.length() - 1);
                }
                return ret;
            }
            catch (ParseErrorException e) {
                this.log.error("Error in interpolating string literal", e);
            }
            catch (MethodInvocationException e) {
                this.log.error("Error in interpolating string literal", e);
            }
            catch (ResourceNotFoundException e) {
                this.log.error("Error in interpolating string literal", e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                this.log.error("Error in interpolating string literal", e);
            }
        }
        return this.image;
    }
}

