/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Sets;
import clover.it.unimi.dsi.fastutil.booleans.BooleanCollection;
import clover.it.unimi.dsi.fastutil.booleans.BooleanCollections;
import clover.it.unimi.dsi.fastutil.booleans.BooleanSets;
import clover.it.unimi.dsi.fastutil.objects.AbstractObject2BooleanMap;
import clover.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Object2BooleanMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    private Object2BooleanMaps() {
    }

    public static Object2BooleanMap singleton(Object key, boolean value) {
        return new Singleton(key, value);
    }

    public static Object2BooleanMap singleton(Object key, Object value) {
        return new Singleton(key, (Boolean)value);
    }

    public static Object2BooleanMap synchronize(Object2BooleanMap m) {
        return new SynchronizedMap(m);
    }

    public static Object2BooleanMap synchronize(Object2BooleanMap m, Object sync) {
        return new SynchronizedMap(m, sync);
    }

    public static Object2BooleanMap unmodifiable(Object2BooleanMap m) {
        return new UnmodifiableMap(m);
    }

    public static class UnmodifiableMap
    extends AbstractObject2BooleanMap
    implements Object2BooleanMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object2BooleanMap map;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected UnmodifiableMap(Object2BooleanMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
        }

        public Object remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return this.map.get(ok);
        }

        public int size() {
            return this.map.size();
        }

        public boolean containsKey(Object k) {
            return this.map.containsKey(k);
        }

        public boolean containsValue(boolean v) {
            return this.map.containsValue(v);
        }

        public boolean defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        public void defaultReturnValue(boolean defRetValue) {
            throw new UnsupportedOperationException();
        }

        public boolean put(Object k, boolean v) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Object2BooleanMap c) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.unmodifiable((ObjectSet)this.map.entrySet());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ObjectSets.unmodifiable((ObjectSet)this.map.keySet());
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return BooleanCollections.unmodifiable((BooleanCollection)((BooleanCollection)this.map.values()));
            }
            return this.values;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.map.toString();
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object ov) {
            return this.map.containsValue(ov);
        }

        public boolean removeBoolean(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean(Object k) {
            return this.map.getBoolean(k);
        }
    }

    public static class SynchronizedMap
    extends AbstractObject2BooleanMap
    implements Object2BooleanMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object2BooleanMap map;
        protected final Object sync;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected SynchronizedMap(Object2BooleanMap m, Object sync) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = sync;
        }

        protected SynchronizedMap(Object2BooleanMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(boolean v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(boolean defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.map.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(Object k, boolean v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Object2BooleanMap c) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map m) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.synchronize((ObjectSet)this.map.entrySet(), this.sync);
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ObjectSets.synchronize((ObjectSet)this.map.keySet(), this.sync);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return BooleanCollections.synchronize((BooleanCollection)((BooleanCollection)this.map.values()), (Object)this.sync);
            }
            return this.values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object k, Object v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object ov) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(ov);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeBoolean(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.removeBoolean(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getBoolean(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.getBoolean(k);
            }
        }
    }

    public static class Singleton
    extends AbstractObject2BooleanMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object key;
        protected final boolean value;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected Singleton(Object key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(Object k) {
            return this.key == null ? k == null : this.key.equals(k);
        }

        public boolean containsValue(boolean v) {
            return this.value == v;
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.singleton(new SingletonEntry());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ObjectSets.singleton(this.key);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = BooleanSets.singleton((boolean)this.value);
            }
            return this.values;
        }

        public boolean getBoolean(Object k) {
            if (this.key == null ? k == null : this.key.equals(k)) {
                return this.value;
            }
            return this.defRetValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }

        private class SingletonEntry
        implements Object2BooleanMap.Entry {
            private SingletonEntry() {
            }

            public Object getKey() {
                return Singleton.this.key;
            }

            public Object getValue() {
                return Singleton.this.value;
            }

            public boolean getBooleanValue() {
                return Singleton.this.value;
            }

            public boolean setValue(boolean value) {
                throw new UnsupportedOperationException();
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return (Singleton.this.key == null ? e.getKey() == null : Singleton.this.key.equals(e.getKey())) && Singleton.this.value == (Boolean)e.getValue();
            }

            public int hashCode() {
                return (Singleton.this.key == null ? 0 : Singleton.this.key.hashCode()) ^ (Singleton.this.value ? 1231 : 1237);
            }

            public String toString() {
                return Singleton.this.key + "->" + Singleton.this.value;
            }
        }
    }

    public static class EmptyMap
    extends AbstractObject2BooleanMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        public boolean put(Object k, boolean v) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return null;
        }

        public boolean containsKey(Object k) {
            return false;
        }

        public boolean containsValue(boolean v) {
            return false;
        }

        public boolean defaultReturnValue() {
            return false;
        }

        public void defaultReturnValue(boolean defRetValue) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return Sets.EMPTY_SET;
        }

        public Set keySet() {
            return Sets.EMPTY_SET;
        }

        public Collection values() {
            return Sets.EMPTY_SET;
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object ov) {
            return false;
        }

        public boolean getBoolean(Object k) {
            return false;
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        public Object clone() {
            return EMPTY_MAP;
        }
    }
}

